(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    979717,      24015]
NotebookOptionsPosition[    946480,      23478]
NotebookOutlinePosition[    946950,      23495]
CellTagsIndexPosition[    946907,      23492]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Cyclic Orthodiagonal Quadrilaterals", "Title",
 CellChangeTimes->{{3.947133122765019*^9, 3.947133141273266*^9}, 
   3.947147906503248*^9, {3.9471622861437607`*^9, 3.947162287750935*^9}, {
   3.9472663408247128`*^9, 
   3.9472663449929256`*^9}},ExpressionUUID->"29001ab6-6556-7b4b-a45f-\
7ca429ca0ceb"],

Cell["\<\
This Notebook contains the proofs for the results about cyclic orthodiagonal \
quadrilaterals in the paper \"More Relationships between a Central \
Quadrilateral and its Reference Quadrilateral\[CloseCurlyDoubleQuote]
by Stanley Rabinowitz and Ercole Suppa, submitted to the International \
Journal of Computer Discovered Mathematics (http://www.journal-1.eu/) in \
February 2025.

This Notebook is Copyright \[Copyright] February 2025 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and Ercole Suppa (ercolesuppa@gmail.com) and is \
published with open access . 
This Notebook is distributed under the terms of the Creative Commons \
Attribution License which permits any use, distribution, and reproduction in \
any medium, provided the original author and the source are credited. 
The baricentricas package must be loaded before running this Notebook . It \
can be obtained from http://garciacapitan.epizy.com/baricentricas/.\
\>", "Text",
 CellChangeTimes->{{3.947134015183899*^9, 3.947134126514601*^9}, {
  3.947134165027289*^9, 3.947134216283169*^9}, {3.947146196077376*^9, 
  3.947146197937656*^9}, {3.947147714654799*^9, 3.947147721422184*^9}, {
  3.947147756182218*^9, 3.947147799085409*^9}, {3.947147829468706*^9, 
  3.947147925478302*^9}, {3.947162294038662*^9, 3.947162295062664*^9}, {
  3.9472663513611603`*^9, 
  3.947266355800377*^9}},ExpressionUUID->"08758b0a-705f-b842-b1d6-\
6a28a79b6218"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.94550589477663*^9, 3.9455059090976067`*^9}, {
  3.947131190260437*^9, 
  3.947131192227951*^9}},ExpressionUUID->"5e4c6aa2-710c-4599-941e-\
5f13e499af78"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "baricentricas.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", ">", "0"}], ",", 
     RowBox[{"b", ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "b", "-", "c"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "c", "-", "b"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"b", "+", "c", "-", "a"}], ">", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ptD", "=", 
    RowBox[{"{", 
     RowBox[{"p", ",", "q", ",", "r"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"condition", " ", "of", " ", "cyclicity"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"cyclic", "=", 
  RowBox[{
   RowBox[{"Sustituirxyz", "[", 
    RowBox[{"circunscrita", ",", "ptD"}], "]"}], "==", "0"}]}]}], "Input",
 CellChangeTimes->{{3.945504565162958*^9, 3.94550458198252*^9}, {
   3.9455170892604294`*^9, 3.945517091156999*^9}, {3.946437513579389*^9, 
   3.946437514387348*^9}, {3.946437922994858*^9, 3.946437998083948*^9}, {
   3.947131229988783*^9, 3.9471312337408752`*^9}, {3.94713126947538*^9, 
   3.947131271053065*^9}, {3.9471314397563486`*^9, 3.947131528028438*^9}, {
   3.947131689741032*^9, 3.947131695924305*^9}, {3.947131733918829*^9, 
   3.947131775067988*^9}, 3.94713185451009*^9, {3.947132455427481*^9, 
   3.947132456035076*^9}, {3.947133799219084*^9, 3.947133799613205*^9}, {
   3.9471624606466045`*^9, 3.9471624614180145`*^9}, 3.947162515937668*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], "\[Equal]", 
  "0"}]], "Output",
 CellChangeTimes->{3.9471628770241*^9, 3.947163230027064*^9, 
  3.947171547777752*^9, 3.947266596370615*^9, 3.9472667609998283`*^9, 
  3.947267410288774*^9, 3.9475690950407753`*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"44a1e5e3-d71e-2a42-b8c2-4a18f4dc475e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"orthodiagonal", "=", 
  RowBox[{
   RowBox[{"Last", "[", 
    RowBox[{"First", "[", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"ptA", ",", "ptC"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"ptB", ",", "ptD"}], "]"}]}], "]"}], "]"}], "]"}], "==", 
   "0"}]}]], "Input",
 CellChangeTimes->{{3.946005912776535*^9, 3.946005919614649*^9}, {
  3.9460201759077435`*^9, 3.946020231172358*^9}, {3.946020292612356*^9, 
  3.9460203113878746`*^9}, {3.947266578273331*^9, 3.947266590201195*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"0fa13524-efd5-b142-bee7-4031f8b5afde"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "p"}], "+", "r"}], ")"}]}], "+", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "r"}], ")"}]}], "-", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "r"}], ")"}]}]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{
  3.946005920062334*^9, 3.946019948035054*^9, 3.946020231916754*^9, {
   3.9460202954247303`*^9, 3.946020312229063*^9}, 3.946023806344425*^9, 
   3.946455141224972*^9, 3.94670535816387*^9, 3.946720762406834*^9, 
   3.946789258333212*^9, 3.947266598699955*^9, 3.9472667610187855`*^9, 
   3.9472674103157024`*^9, 3.9475690953828583`*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"229534fb-6fc5-924e-9984-0e51a2819b41"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sols", "=", 
  RowBox[{"Quiet", "[", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"cyclic", ",", "orthodiagonal"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "q", ",", "r"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.946005930352354*^9, 3.946005952534466*^9}, {
  3.946020256211817*^9, 3.946020256892193*^9}, {3.94602031941992*^9, 
  3.946020352715191*^9}, {3.947266633001116*^9, 3.947266635970049*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"87df9985-2672-474d-a525-2ead7c5a73f6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "\[Rule]", "0"}], ",", 
     RowBox[{"r", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"q", "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", 
         SuperscriptBox["b", "2"], " ", "p"}], "+", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", "p"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"], " ", "p"}]}], 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}]]}], ",", 
     RowBox[{"r", "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", "p"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "p"}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "p"}]}], 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9460203256386623`*^9, 3.946020353937216*^9}, 
   3.94602380741502*^9, 3.9464551412783127`*^9, 3.9467053582217007`*^9, 
   3.946720762458729*^9, 3.946789258384115*^9, {3.9472666278190823`*^9, 
   3.947266636801014*^9}, 3.9472667610347214`*^9, 3.947267410337643*^9, 
   3.9475690954610424`*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"c921d4d4-440a-1544-9eb5-8b2c5114dbfb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptD", "=", 
  RowBox[{"-", 
   RowBox[{"Simplificar", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", "q", ",", "r"}], "}"}], "/.", 
     RowBox[{"sols", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.946007594513643*^9, 3.946007611417134*^9}, {
   3.946020361556525*^9, 3.946020400563959*^9}, 3.9472666712730103`*^9},
 CellLabel->"In[7]:=",ExpressionUUID->"b1253ee8-a010-d14b-9c7e-3b5e0e72737d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.9460203725651054`*^9, 3.946020407641279*^9, 3.94602380853841*^9, 
   3.946455141293277*^9, 3.9467053582356358`*^9, 3.946720762472658*^9, 
   3.946789258399071*^9, {3.947266648347981*^9, 3.947266671988085*^9}, 
   3.947266761042721*^9, 3.947267410346619*^9, 3.947569095474016*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"989c4f15-b8e9-0e4d-87c8-d821ff46140c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cortho", "=", 
  RowBox[{"cyclic", "&&", "orthodiagonal"}]}]], "Input",
 CellChangeTimes->{{3.946455165590822*^9, 3.9464552021475716`*^9}, {
  3.946705695210943*^9, 3.94670569535524*^9}, {3.9472666581202354`*^9, 
  3.947266661577027*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"893fef3b-ebfc-114c-858b-2d8fe70902bb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "p"}], "+", "r"}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "r"}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "r"}], ")"}]}]}], "\[Equal]", "0"}]}]], "Output",
 CellChangeTimes->{3.946455204099876*^9, 3.9467053582396297`*^9, 
  3.9467056970919094`*^9, 3.94672076248765*^9, 3.946789258403057*^9, 
  3.947266662905257*^9, 3.947266761047682*^9, 3.947267410354599*^9, 
  3.9475690954809895`*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"c6e87078-e858-4b47-817d-b45b9b85196e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Support routines", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
  3.850469071318833*^9, 3.850469073637095*^9}, {3.850469177050805*^9, 
  3.85046919499736*^9}},ExpressionUUID->"cf60f297-bbcd-8748-b453-\
e7118b4e0a98"],

Cell[CellGroupData[{

Cell["QAP centers", "Subsection",
 CellChangeTimes->{{3.945853740709931*^9, 3.945853743438184*^9}, {
  3.9464394595455627`*^9, 
  3.9464394652171745`*^9}},ExpressionUUID->"c8cca55e-04f1-8f4a-b670-\
3c3179eed91e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP", "=", 
   RowBox[{"<|", 
    RowBox[{
     RowBox[{"1", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ",", 
        RowBox[{"p", "+", 
         RowBox[{"2", " ", "q"}], "+", "r"}], ",", 
        RowBox[{"p", "+", "q", "+", 
         RowBox[{"2", " ", "r"}]}]}], "}"}]}], ",", 
     RowBox[{"2", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", " ", "SB"}], "-", 
           RowBox[{"r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "SA"}], "+", 
           RowBox[{"r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "SA"}], "-", 
           RowBox[{"q", " ", "SB"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"3", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}]}], 
          ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", 
              RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"4", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", "SA"}], "-", 
           RowBox[{"2", " ", "p", " ", "q", " ", "SA"}], "-", 
           RowBox[{"2", " ", "p", " ", "r", " ", "SA"}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}]}], ")"}]}],
         ",", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p"}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q"}], "-", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}], 
             ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"5", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"6", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"q", " ", 
                SuperscriptBox["SB", "2"]}], "-", 
               RowBox[{"r", " ", 
                SuperscriptBox["SC", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"q", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"p", " ", 
                SuperscriptBox["SA", "2"]}], "-", 
               RowBox[{"r", " ", 
                SuperscriptBox["SC", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"p", " ", 
                SuperscriptBox["SA", "2"]}], "-", 
               RowBox[{"q", " ", 
                SuperscriptBox["SB", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"7", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SB", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 SuperscriptBox["SB", "2"], "+", 
                 RowBox[{"2", " ", "SB", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"2", " ", "SB", " ", "SC"}], "+", 
                 SuperscriptBox["SC", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
           RowBox[{"q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"3", " ", "r", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"r", " ", "SC", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "SA"}], "+", "SC"}], ")"}]}], "+", 
              RowBox[{"p", " ", "SA", " ", 
               RowBox[{"(", 
                RowBox[{"SA", "+", 
                 RowBox[{"2", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"2", " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SA", " ", "SC"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"3", " ", "q", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"q", " ", "SB", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "SA"}], "+", "SB"}], ")"}]}], "+", 
              RowBox[{"p", " ", "SA", " ", 
               RowBox[{"(", 
                RowBox[{"SA", "+", 
                 RowBox[{"2", " ", "SB"}]}], ")"}]}], "+", 
              RowBox[{"2", " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SA", " ", "SB"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}],
        "}"}]}], ",", 
     RowBox[{"8", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "p"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "p"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "q"}], "+", 
            RowBox[{"4", " ", "r", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}]}], "}"}]}],
      ",", 
     RowBox[{"9", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p", " ", "q"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["q", "2"]}], "+", 
                 RowBox[{"3", " ", "p", " ", "r"}], "+", 
                 RowBox[{"q", " ", "r"}], "-", 
                 SuperscriptBox["r", "2"]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "p", " ", "q"}], "-", 
                 SuperscriptBox["q", "2"], "+", 
                 RowBox[{"2", " ", "p", " ", "r"}], "+", 
                 RowBox[{"q", " ", "r"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "q"}], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"4", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "q"}], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "-", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"5", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"3", " ", "p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "8"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "8"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", 
                 RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"p", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], 
              "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"p", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"8", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"4", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["c", "6"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["p", "2"]}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "q", " ", 
                  SuperscriptBox["r", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"12", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"9", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["q", "3"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"12", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"9", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"13", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "2"]}], " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "r"}], "-", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"2", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["p", "2"], "-", 
                 RowBox[{"2", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "6"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "q", " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"5", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "-", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["q", "2"], " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "3"}], " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", 
                  SuperscriptBox["q", "3"], " ", "r"}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  SuperscriptBox["r", "3"]}], "+", 
                 RowBox[{"8", " ", 
                  SuperscriptBox["p", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"8", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "3"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"9", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"12", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["c", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["q", "2"]}]}], ")"}], " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "2"]}], " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "+", "q"}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "r"}], "-", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "6"]}], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["p", "2"]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["q", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"5", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "-", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["q", "2"], " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"8", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"6", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "3"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["q", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "-", 
                    RowBox[{"2", " ", "q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"12", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"13", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"9", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"10", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"11", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"12", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
          ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", "q", " ", "SB"}], "+", 
           RowBox[{"p", " ", "r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{"p", " ", "q", " ", "SA"}], "+", 
           RowBox[{"q", " ", "r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r", " ", "SA"}], "+", 
           RowBox[{"q", " ", "r", " ", "SB"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", "q", " ", 
            SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"13", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"14", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "r"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"5", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"2", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "q"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"2", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}]}], "}"}]}], 
     ",", 
     RowBox[{"15", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "q"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", 
               RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"q", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["q", "2"]}], "+", 
               RowBox[{"5", " ", "q", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"5", " ", "q", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["p", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["q", "2"]}], "+", 
               RowBox[{"22", " ", "q", " ", "r"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "p"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"5", " ", "p", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"5", " ", "p", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["q", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["q", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"22", " ", "p", " ", "r"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["q", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               SuperscriptBox["q", "2"]}], ")"}], " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "p"}], "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"5", " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"5", " ", "p", " ", "q"}], "+", 
               SuperscriptBox["q", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"5", " ", "p", " ", "q"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["q", "2"]}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"22", " ", "p", " ", "q"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["q", "2"]}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"10", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "4"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"16", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"17", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["q", "2"], "+", 
              SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{"q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"18", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"19", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"20", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"21", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"22", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"3", " ", "p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"23", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", "q", " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
         RowBox[{"p", " ", "q", " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
         RowBox[{"p", " ", "r", " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", "SB"}]}]}], "}"}]}], ",", 
     RowBox[{"24", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", "SB", " ", 
          "SC"}], "-", 
         RowBox[{"4", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "SC"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], ")"}], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", "SC"}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", "SA", " ", 
          "SC"}], "-", 
         RowBox[{"4", " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "SC"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], ")"}], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", "SC"}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", "SA", " ", 
          "SB"}], "-", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"25", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"2", " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"26", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"5", " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"5", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"5", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"27", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["p", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "3"], " ", "q"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"p", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{"q", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "3"]}], " ", "q"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           SuperscriptBox["q", "4"], "+", 
           RowBox[{
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"q", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["p", "3"], " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"2", " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           SuperscriptBox["r", "4"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"28", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "4"]}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["p", "2"]}], "+", 
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["b", "2"], "-", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", "r"}]}], 
             ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SuperscriptBox["p", "2"]}], "+", 
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "4"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["q", "2"]}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["q", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "+", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", "r"}], "+", 
              RowBox[{
               SuperscriptBox["a", "4"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["q", "2"]}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"3", " ", "q", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", 
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "q", "+", 
                RowBox[{"2", " ", "r"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["a", "2"], "-", 
                   SuperscriptBox["b", "2"]}], ")"}], " ", "p", " ", "q"}], 
                "+", 
                RowBox[{
                 SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "4"], " ", "q", " ", "r"}]}], ")"}]}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"3", " ", "q", " ", "r"}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
       "}"}]}], ",", 
     RowBox[{"29", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["a", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "3"], " ", "r"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["p", "2"]}], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"30", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "q"}], ")"}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "r"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "-", 
              RowBox[{"3", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "q"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "p"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", 
              RowBox[{"3", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "-", "r"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "p"}], "+", "q"}], ")"}], " ", "r", 
            " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", 
              RowBox[{"3", " ", "q"}]}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "q"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], 
       "}"}]}], ",", 
     RowBox[{"31", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"32", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"2", " ", "p", " ", "q", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}]}], "}"}]}],
      ",", 
     RowBox[{"33", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB", " ", 
             "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA", " ", 
             "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA", " ", 
             "SB"}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"34", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "p"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"4", " ", "q"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "p"}], "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"35", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"15", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "3"], " ", "r"}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"5", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"15", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"12", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"5", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["p", "2"]}], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"15", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"15", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"12", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"36", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["c", "2"]}], " ", "q"}], "-", 
               RowBox[{
                SuperscriptBox["b", "2"], " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "-", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q", " ", "r"}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["b", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "+", 
               RowBox[{
                SuperscriptBox["a", "4"], " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["b", "4"], " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["c", "2"]}], " ", "p"}], "-", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"p", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "p"}], "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "r"}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "4"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["b", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["c", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["b", "2"], " ", 
                SuperscriptBox["c", "2"], " ", "q", " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["b", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["c", "4"], " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "-", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "-", "q"}], ")"}], " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "q"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}]}], ")"}]}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["b", "2"]}], " ", "p"}], "-", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "4"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["c", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["a", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["c", "4"], " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "p"}], "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}]}], "}"}]}], ",", 
     RowBox[{"37", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"p", " ", "q", " ", "SB"}], "+", 
            RowBox[{"p", " ", "r", " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"p", " ", "q", " ", "SA"}], "+", 
            RowBox[{"q", " ", "r", " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r", " ", "SA"}], "+", 
            RowBox[{"q", " ", "r", " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"38", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["b", "2"]}], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "-", "q", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", "p"}], "+", "q", "+", "r"}], 
                ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", 
                 RowBox[{"2", " ", "q"}], "-", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", 
                 RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "q", "+", 
             RowBox[{"2", " ", "r"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "q", "-", 
                RowBox[{"2", " ", "r"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "-", "q", "-", 
                   RowBox[{"2", " ", "r"}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "-", "q", "+", 
                   RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
          ")"}]}]}], "}"}]}], ",", 
     RowBox[{"39", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["b", "2"], "-", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "-", "r"}], ")"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"p", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "+", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "p"}], "+", "r"}], ")"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               RowBox[{"2", " ", "p", " ", "r"}], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["a", "2"], "-", 
                 SuperscriptBox["b", "2"]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", "q"}], ")"}], " ", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "q"}], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}]}], "}"}]}], ",", 
     RowBox[{"40", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], "+", 
            SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", 
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"q", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "p"}], "+", 
                   RowBox[{"2", " ", "q"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "q"}], "+", 
                  RowBox[{"6", " ", 
                   SuperscriptBox["q", "2"]}]}], ")"}], " ", "r"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", "p"}], "+", 
                  RowBox[{"2", " ", "q"}]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "r", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", 
                  RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["p", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", "q"}], "+", 
                  RowBox[{"9", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", 
                   SuperscriptBox["q", "2"]}], "+", 
                  RowBox[{"15", " ", "q", " ", "r"}], "+", 
                  RowBox[{"12", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"6", " ", "p", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["a", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["q", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"9", " ", "p"}], "+", 
                  RowBox[{"7", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"12", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "r"}], "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "q"}], "+", 
                   RowBox[{"2", " ", "r"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                SuperscriptBox["p", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", "q"}], "+", 
                  RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", 
                   SuperscriptBox["q", "2"]}], "+", 
                  RowBox[{"15", " ", "q", " ", "r"}], "+", 
                  RowBox[{"6", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"6", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], "+", 
            SuperscriptBox["b", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}], "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", 
                  RowBox[{"2", " ", "q"}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "q"}], "+", 
                  RowBox[{"12", " ", 
                   SuperscriptBox["q", "2"]}]}], ")"}], " ", "r"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", "p"}], "+", 
                  RowBox[{"9", " ", "q"}]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", "p"}], "+", 
                   RowBox[{"3", " ", "r"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                SuperscriptBox["q", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "p"}], "+", 
                  RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"6", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "r"}], "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"41", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "4"]}], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "4"]}], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"42", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q", " ", "r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "SB"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"43", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", "p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", "p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"44", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "q"}], "-", 
            RowBox[{"q", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p", " ", "q"}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            SuperscriptBox["q", "3"], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            SuperscriptBox["r", "3"]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", "q", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "3"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            SuperscriptBox["r", "3"]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"3", " ", "q"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"4", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"2", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "3"], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            SuperscriptBox["q", "3"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}]}], "|>"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945841589546528*^9, 3.945841604944151*^9}, {
   3.9458416486015606`*^9, 3.945841701130226*^9}, 3.94584180266897*^9, {
   3.945841855521532*^9, 3.945841865133842*^9}, {3.9458419743855267`*^9, 
   3.94584197851943*^9}, {3.945842012120521*^9, 3.945842016064451*^9}, {
   3.945842114756489*^9, 3.945842119338508*^9}, {3.945842170028664*^9, 
   3.945842174123476*^9}, {3.945842254968681*^9, 3.9458422593104534`*^9}, {
   3.94584246069957*^9, 3.945842465998068*^9}, {3.945842501032144*^9, 
   3.9458425325383263`*^9}, {3.945842735167492*^9, 3.945842742091593*^9}, {
   3.945842846919035*^9, 3.945842850061655*^9}, {3.945842936494915*^9, 
   3.945842969633366*^9}, {3.945843125849571*^9, 3.94584313274209*^9}, {
   3.945843174894972*^9, 3.945843178277809*^9}, {3.9458432197775517`*^9, 
   3.9458432370243473`*^9}, {3.945843287330616*^9, 3.9458432907977543`*^9}, {
   3.945843326923149*^9, 3.9458433430906563`*^9}, {3.945843384493232*^9, 
   3.945843387811741*^9}, {3.945843423557177*^9, 3.945843427076299*^9}, {
   3.9458460856414566`*^9, 3.9458460903603935`*^9}, {3.9458461244501*^9, 
   3.945846127392929*^9}, {3.945846273464027*^9, 3.945846279270181*^9}, {
   3.945846311960058*^9, 3.945846315350111*^9}, {3.945846366817175*^9, 
   3.945846382831234*^9}, {3.945846756353731*^9, 3.9458467662170296`*^9}, {
   3.945846811099188*^9, 3.945846841686339*^9}, {3.945846884211832*^9, 
   3.945847260236458*^9}, {3.945847371762398*^9, 3.9458473779483223`*^9}, {
   3.945847468577452*^9, 3.945847473866535*^9}, {3.9458476375888367`*^9, 
   3.945847641254919*^9}, {3.945847770316178*^9, 3.9458477741893463`*^9}, {
   3.94584781182493*^9, 3.9458478153183575`*^9}, {3.94584788583465*^9, 
   3.945847888720951*^9}, {3.94584794845273*^9, 3.9458479545306664`*^9}, {
   3.945848036235821*^9, 3.945848039850874*^9}, {3.945848209145437*^9, 
   3.945848213365254*^9}, {3.945848428704586*^9, 3.945848437990104*^9}, {
   3.945848526693582*^9, 3.945848534626331*^9}, {3.945848666528978*^9, 
   3.94584868269029*^9}, {3.945848775077949*^9, 3.945848778998434*^9}, {
   3.945848877398905*^9, 3.945848886629158*^9}, {3.9458491238654*^9, 
   3.945849128054989*^9}, {3.945849197156975*^9, 3.9458492011715355`*^9}, {
   3.9458492397412167`*^9, 3.945849244243763*^9}, 3.945849479846901*^9, {
   3.945851715909244*^9, 3.945851732617178*^9}, 3.945853235726444*^9, {
   3.945853633264748*^9, 3.9458536354922667`*^9}, {3.946058981146543*^9, 
   3.946058983238126*^9}, {3.946113816440451*^9, 3.946113833217655*^9}, 
   3.946113923272053*^9, 3.9462998579964046`*^9},
 CellLabel->"In[10]:=",ExpressionUUID->"90297db1-2eea-6346-9338-a3e8dcfe0024"]
}, Closed]],

Cell[CellGroupData[{

Cell["QAP constructions", "Subsection",
 CellChangeTimes->{{3.946258018000845*^9, 3.9462580514460297`*^9}, {
  3.946439582465828*^9, 
  3.94643958360841*^9}},ExpressionUUID->"79ef6085-3de7-3c49-8561-\
f943fbd2d431"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP1", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258220966779*^9, 3.946258253166219*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"e725b315-4161-274c-8798-a4e0c807d6a8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP2", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"PonceletPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258127112749*^9, 3.946258205014044*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"60fea3de-a36e-734d-b67f-75eab8f36838"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP3", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258267006763*^9, 3.946258272798765*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"422bd8e2-a85e-d748-b542-6c9b62c11efd"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP4", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsogonal", "[", 
        RowBox[{"P", ",", 
         RowBox[{"{", 
          RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsogonal", "[", 
        RowBox[{"Q", ",", 
         RowBox[{"{", 
          RowBox[{"P", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258285271057*^9, 3.946258529254532*^9}, {
  3.946258821686931*^9, 3.946258862614427*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"d021f1ab-c58d-b74b-8aa5-a62365464cc5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP5", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsotomico", "[", 
        RowBox[{"P", ",", 
         RowBox[{"{", 
          RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", "P"}], 
      "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsotomico", "[", 
        RowBox[{"Q", ",", 
         RowBox[{"{", 
          RowBox[{"P", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", "Q"}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946552139912605*^9, 3.946552177047758*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"023d4850-e194-b941-a762-4c9a532e11d1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP6", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Medio", "[", 
    RowBox[{
     RowBox[{"QAP2", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}], ",", 
     RowBox[{"QAP4", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946554002925066*^9, 3.946554042045203*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"62ef2468-c328-714d-8bf7-299b142a086d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP7", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Q1", ",", "Q2", ",", "Q3", ",", "Q4", ",", "R1", ",", "R2"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Q1", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q2", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q3", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q4", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"R1", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q2", ",", "Q3", ",", "Q4"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"R2", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q1", ",", "Q3", ",", "Q4"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R1"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R2"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946258285271057*^9, 3.946258529254532*^9}, {
  3.946258821686931*^9, 3.946258862614427*^9}, {3.946290848591799*^9, 
  3.946291021534954*^9}, {3.946291111031261*^9, 3.946291120455242*^9}, {
  3.946696200711548*^9, 3.946696200806263*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"d734f707-6812-364b-b359-ac3a6bb66e72"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MiquelPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"U", ",", "V", ",", "O1", ",", "O2"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"U", "=", 
       RowBox[{"Punto", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "Q"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"V", "=", 
       RowBox[{"Punto", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "S"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"O1", "=", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "S", ",", "U"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"O2", "=", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"R", ",", "S", ",", "V"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SimetriaAxial", "[", 
       RowBox[{"S", ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"O1", ",", "O2"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]",
     "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946294457093628*^9, 3.946294688202664*^9}, {
   3.9462961458488*^9, 3.9462961471441994`*^9}, 3.9462963028076897`*^9, {
   3.9462973681984005`*^9, 3.946297370950136*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"34f7e383-98aa-bc47-9867-166186424dd4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MiquelCircle", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"U", ",", "V", ",", "W", ",", "O1", ",", "O2", ",", "O3"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"U", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"V", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O1", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "S", ",", "U"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O2", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"R", ",", "S", ",", "V"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O3", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"Q", ",", "R", ",", "U"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CircunferenciaTresPuntos", "[", 
      RowBox[{"{", 
       RowBox[{"O1", ",", "O2", ",", "O3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946295931650831*^9, 3.9462959921519623`*^9}, {
  3.9462960978401566`*^9, 3.946296126960247*^9}, {3.946296309416164*^9, 
  3.946296387663599*^9}, {3.946296507206955*^9, 3.946296515015978*^9}, {
  3.9462965951590157`*^9, 3.9462966339272327`*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"4370c731-693f-a941-82c8-1f6a14f724b2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP8", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"SimetriaCentral", "[", 
    RowBox[{
     RowBox[{"QAP4", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}], ",", 
     RowBox[{"QAP2", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946554262541748*^9, 3.946554276084837*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"6e2024d9-4541-ea4e-a308-49a8bb9b87a5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP9", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c1", ",", "c2", ",", "c3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"c1", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"c2", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "Q", ",", "S", ",", "R"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"c3", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "R", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CentroRadical", "[", 
      RowBox[{"c1", ",", "c2", ",", "c3"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9462975678957386`*^9, 3.94629768995805*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"384fc915-4ebd-5342-9174-a166a5e7f52d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP10", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Baricentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946554372389721*^9, 3.94655438207695*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"e878baba-ea71-dd4f-b972-2e4c3753c774"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP11", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Circuncentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946554416053346*^9, 3.946554423653038*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"4200ee2b-abeb-b246-85fa-68f1ce5d836b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP12", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Ortocentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellLabel->"In[24]:=",ExpressionUUID->"8131db8a-5012-e741-93f3-ec6da52923f1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP34", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1", ",", "P2", ",", "P3", ",", "P4"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"P1", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P2", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P3", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P4", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"QAP2", "[", 
       RowBox[{"{", 
        RowBox[{"P1", ",", "P2", ",", "P3", ",", "P4"}], "}"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946362022452154*^9, 3.9463621697479362`*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"3e5eb206-464c-7e4f-b628-98c50c5a4629"]
}, Closed]],

Cell[CellGroupData[{

Cell["Auxiliary functions", "Subsection",
 CellChangeTimes->{
  3.818667972143658*^9, {3.8186680382464933`*^9, 3.818668041714528*^9}, {
   3.818668136826049*^9, 3.818668143553762*^9}, {3.818685183717651*^9, 
   3.818685185711126*^9}},ExpressionUUID->"d004e03f-8f12-9a43-865f-\
339812029417"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "powers", " ", "of", " ", 
     "S"}], "=", 
    RowBox[{"2", "[", "ABC", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], "/", "4"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustS", "=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["S", "n_"], "\[Rule]", 
       RowBox[{
        SuperscriptBox["S2", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]], 
        SuperscriptBox["S", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}]]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "Conway", " ", "symbols"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SA", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SB", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SC", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SW", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"EqualPointsQ", "[", 
      RowBox[{"ptP_", ",", "ptQ_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cross", "[", 
           RowBox[{"ptP", ",", "ptQ"}], "]"}], "/.", "sustS"}], "/.", 
         "sustC"}], ",", "cond"}], "]"}], "===", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.947132996916015*^9, 3.9471330125156*^9}, {
  3.947133479684403*^9, 3.947133480044634*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"059a14ad-548f-1d43-b181-7239fd1e5301"]
}, Closed]],

Cell[CellGroupData[{

Cell["Quadrilateral routines", "Subsection",
 CellChangeTimes->{{3.945509919017998*^9, 
  3.945509932600797*^9}},ExpressionUUID->"2a49be25-3c4e-430e-86c6-\
869880736f30"],

Cell[CellGroupData[{

Cell["Vertex centroid", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.947132319963703*^9, 
  3.947132328106987*^9}},ExpressionUUID->"a576f9af-1f5b-4213-b4d3-\
e7b66981337e"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzs3Qd8FGX+P3D+v7v7nb+zAPZTT7EgoJyn56moZ0fQKBq6dIggATVSgmBo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    "], {{0, 389.2075471698113}, {491.0943396226415, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{491.0943396226415, 389.2075471698113},
  PlotRange->{{0, 491.0943396226415}, {0, 389.2075471698113}}]], "Text",
 CellChangeTimes->{
  3.945509787103263*^9},ExpressionUUID->"f7950398-57cb-4ee6-bf14-\
597b39eb91df"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"Medio", "[", 
        RowBox[{"P", ",", "Q"}], "]"}], ",", 
       RowBox[{"Medio", "[", 
        RowBox[{"R", ",", "S"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"Medio", "[", 
        RowBox[{"P", ",", "S"}], "]"}], ",", 
       RowBox[{"Medio", "[", 
        RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
  3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
  3.9455136200666037`*^9}, {3.946439211017157*^9, 3.946439211737526*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"cf738f77-0d96-4e62-81a0-f2a504594dc8"]
}, Closed]],

Cell[CellGroupData[{

Cell["Poncelet point", "Subsubsection",
 CellChangeTimes->{{3.945509682961616*^9, 3.945509705247427*^9}, {
   3.945516718286007*^9, 3.945516720220911*^9}, 
   3.947132291355841*^9},ExpressionUUID->"f7957972-a4e9-446f-bafd-\
6774f0dd3699"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "PuntoDePoncelet", " ", "is", " ", "implemented", " ", "in", " ", "the", 
    " ", "baricentricas", " ", "package"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"PonceletPoint", "[", 
     RowBox[{"{", 
      RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
    RowBox[{"PuntoDePoncelet", "[", 
     RowBox[{"P", ",", 
      RowBox[{"{", 
       RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.945506298668439*^9, 3.9455064957646704`*^9}, {
  3.945508100242526*^9, 3.945508119954049*^9}, {3.9455093671686244`*^9, 
  3.945509538952415*^9}, {3.9455167413982186`*^9, 3.945516826125304*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"44de57fd-6e7d-4d98-94a0-c7b93947eadd"]
}, Closed]],

Cell[CellGroupData[{

Cell["Steiner point", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.947132277507908*^9, 
  3.947132283924074*^9}},ExpressionUUID->"ae32c2db-9871-344f-aabd-\
a2543db56100"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "X", ",", "Y", ",", "Z", ",", "T", ",", "U", ",", "V", ",", "W"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"X", ",", "Y", ",", "Z", ",", "U", ",", "T"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Apply", "[", 
          RowBox[{"Medio", ",", "#"}], "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"P", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "Q"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"R", ",", "Q"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "R"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"S", ",", "Q"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"V", ",", "W"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Circuncentro", "[", "#", "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"X", ",", "Y", ",", "U"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Y", ",", "Z", ",", "T"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SimetriaAxial", "[", 
       RowBox[{"Y", ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"V", ",", "W"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945506298668439*^9, 3.9455064957646704`*^9}, {
  3.945508100242526*^9, 3.945508119954049*^9}, {3.9455093671686244`*^9, 
  3.945509538952415*^9}, {3.945518206235336*^9, 3.945518260181164*^9}, {
  3.945518437370175*^9, 3.9455184493471375`*^9}, {3.947132243612131*^9, 
  3.947132244379742*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"db0fcba9-9144-4df7-981b-db22bb466a6e"]
}, Closed]],

Cell[CellGroupData[{

Cell["Diagonal point", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
   3.945521331783347*^9, 3.9455213360947638`*^9}, 
   3.947132343027188*^9},ExpressionUUID->"29f12ada-9fd0-4747-b323-\
2cf96d6fb52e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"P", ",", "R"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
  3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
  3.9455136200666037`*^9}, {3.945521346455207*^9, 3.9455213813107405`*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"158fb412-c771-43ab-b43b-a357380f4a11"]
}, Closed]],

Cell[CellGroupData[{

Cell["Central quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.9464416787367783`*^9, 3.946441687230852*^9}, 
   3.947147898383025*^9},ExpressionUUID->"5a543829-5641-9144-8dd0-\
57eb7cf1938d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CentralQuadrilateral", "[", "n_", "]"}], ":=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptB", ",", "ptC", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptC", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}]}], "]"}], "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellLabel->"In[34]:=",ExpressionUUID->"35cb8ff3-829e-654a-a95d-e2c972de6be9"]
}, Closed]],

Cell[CellGroupData[{

Cell["Area of a quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 
  3.945509840152308*^9}},ExpressionUUID->"e039afe9-d89d-4ec4-94b9-\
ddb3f9f259e0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AreaQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"AreaTriangulo", "[", 
     RowBox[{"{", 
      RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}], "+", 
    RowBox[{"AreaTriangulo", "[", 
     RowBox[{"{", 
      RowBox[{"R", ",", "S", ",", "P"}], "}"}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945518557002711*^9, 3.945518607763227*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"2db3c5dc-e4da-4371-937a-22cb108c81e1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Perspective quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945619500071995*^9, 3.9456195111611595`*^9}, {
   3.94561961722077*^9, 3.945619628845907*^9}, {3.945620201468649*^9, 
   3.945620207996176*^9}, {3.946093948975952*^9, 3.946093951552325*^9}, 
   3.94619393871496*^9, 
   3.947147899655007*^9},ExpressionUUID->"bd16b166-d506-5544-b5d0-\
7aa6edfca35b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PerspectiveQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "P2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "Q2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"R1", ",", "R2"}], "]"}]}], "}"}], "]"}], "==", "0"}], "&&", 
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "P2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "Q2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"S1", ",", "S2"}], "]"}]}], "}"}], "]"}], "==", 
    "0"}]}]}]], "Input",
 CellChangeTimes->{{3.945619541933253*^9, 3.945619598797678*^9}, {
  3.945620227236483*^9, 3.945620398996369*^9}, {3.946093956887635*^9, 
  3.9460940140877304`*^9}, {3.9460946192084503`*^9, 3.9460946637685833`*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"6cd12b17-ccf6-1f40-8216-e746f72a898c"]
}, Closed]],

Cell[CellGroupData[{

Cell["Similar and homothetic quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 3.945509840152308*^9}, {
  3.945518917754542*^9, 3.945518929298341*^9}, {3.94551954978488*^9, 
  3.945519554745524*^9}, {3.9471326902197247`*^9, 3.9471326941873684`*^9}, {
  3.947132774954735*^9, 
  3.947132785771118*^9}},ExpressionUUID->"d546f79d-5ed9-4f99-846e-\
3ac1a3756b86"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SimilarQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"SonSemejantes", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P1", ",", "Q1", ",", "R1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"P2", ",", "Q2", ",", "R2"}], "}"}]}], "]"}], "&&", 
    RowBox[{"SonSemejantes", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Q1", ",", "R1", ",", "S1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Q2", ",", "R2", ",", "S2"}], "}"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945518557002711*^9, 3.945518607763227*^9}, {
  3.9455189375627*^9, 3.945519039097607*^9}, {3.945519562008997*^9, 
  3.945519564865857*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"5668c7c2-b2f3-48b4-bb4e-3f493e46ab9c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"HomotheticQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"SonHomoteticos", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P1", ",", "Q1", ",", "R1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"P2", ",", "Q2", ",", "R2"}], "}"}]}], "]"}], "&&", 
    RowBox[{"SonHomoteticos", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Q1", ",", "R1", ",", "S1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Q2", ",", "R2", ",", "S2"}], "}"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.9455195703380117`*^9, 3.945519605171223*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"d07dfa48-d9b6-433c-9d4d-8f2532f1bec3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Congruent quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945619500071995*^9, 3.9456195111611595`*^9}, {
   3.94561961722077*^9, 3.945619628845907*^9}, {3.945620201468649*^9, 
   3.945620207996176*^9}, 3.946437820730978*^9, 
   3.9471479009831057`*^9},ExpressionUUID->"8f461d45-0647-c84b-9fe0-\
f72d3601c63f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CongruentQuadQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"And", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P1", ",", "Q1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P2", ",", "Q2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"Q1", ",", "R1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"Q2", ",", "R2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"R1", ",", "S1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"R2", ",", "S2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"S1", ",", "P1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"S2", ",", "P2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P1", ",", "R1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P2", ",", "R2"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945619541933253*^9, 3.945619598797678*^9}, {
  3.945620227236483*^9, 3.945620398996369*^9}, {3.946287549140295*^9, 
  3.946287549827748*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"5485ed32-34f6-e64e-bd2a-b4e163c2b97f"]
}, Closed]],

Cell[CellGroupData[{

Cell["Orthogonal quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.946437760717503*^9, 3.9464377702703495`*^9}, 
   3.947147903551467*^9},ExpressionUUID->"54169a90-c35c-7a4a-a37f-\
78c9753e8eeb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"OrthogonalQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"And", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "Q1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"P2", ",", "Q2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "R1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q2", ",", "R2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"R1", ",", "S1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"R2", ",", "S2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"S1", ",", "P1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"S2", ",", "P2"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9455195703380117`*^9, 3.945519605171223*^9}, {
  3.9460039858449364`*^9, 3.946003994260566*^9}, {3.946004044908913*^9, 
  3.946004131276815*^9}, {3.946004174101141*^9, 3.946004205589377*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"c1bc4c8d-1ecd-654a-b9e2-f902b4037dfa"]
}, Closed]],

Cell[CellGroupData[{

Cell["Conconic quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.946188760871956*^9, 3.946188779525741*^9}, {
  3.9464378271237335`*^9, 
  3.946437830963283*^9}},ExpressionUUID->"e126572d-bdab-a047-b925-\
c2661290f09e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "returns", " ", "TRUE", " ", "if", " ", "ABCD", " ", "and", " ", "EFGH", 
    " ", "are", " ", "conconic"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"conconicQuadQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA_", ",", "ptB_", ",", "ptC_", ",", "ptD_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE_", ",", "ptF_", ",", "ptG_", ",", "ptH_"}], "}"}]}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "conic", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"conic", "=", 
        RowBox[{"ConicaCincoPuntos", "[", 
         RowBox[{"{", 
          RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD", ",", "ptE"}], 
          "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Sustituirxyz", "[", 
            RowBox[{"conic", ",", "#"}], "]"}], "&"}], ",", 
          RowBox[{"{", 
           RowBox[{"ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], "==", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.946440275192674*^9, 3.946440364775547*^9}, {
  3.946557553720074*^9, 3.94655756021654*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"3eac6f83-9820-5d4f-9acd-4f2df1b13510"]
}, Closed]],

Cell[CellGroupData[{

Cell["Find QA center", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 3.945509840152308*^9}, {
  3.945518917754542*^9, 3.945518929298341*^9}, {3.94551954978488*^9, 
  3.945519554745524*^9}, {3.946186993811855*^9, 
  3.946187000755444*^9}},ExpressionUUID->"1d12da59-37f1-9842-ad9c-\
eb916041816f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "findQACenter", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"findQACenter", "[", 
    RowBox[{"ptP_", ",", 
     RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"found", "=", "0"}], ",", "sustCS", ",", 
       RowBox[{"nc", "=", 
        RowBox[{"Length", "[", "QAP", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"sustCS", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"sustS", ",", "sustC"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Monitor", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "<=", "nc"}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"Simplify", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Cross", "[", 
                   RowBox[{"ptP", ",", 
                    RowBox[{"QAP", "[", "i", "]"}]}], "]"}], "//.", 
                  "sustCS"}], ",", "cond"}], "]"}], ")"}], "==", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
             RowBox[{
              RowBox[{"found", "=", "i"}], ";", 
              RowBox[{"Break", "[", "]"}]}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<Identifying the center... \>\"", ",", 
           RowBox[{"ProgressIndicator", "[", 
            RowBox[{"i", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "nc"}], "}"}]}], "]"}], ",", "\"\< \>\"", ",",
            "i", ",", "\"\</\>\"", ",", "nc"}], "}"}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"found", "==", "0"}], ",", "\"\<unknown\>\"", ",", 
        RowBox[{"\"\<QA-P\>\"", "<>", 
         RowBox[{"ToString", "[", "found", "]"}]}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.946187173054329*^9, 3.946187213931603*^9}, {
   3.946187246486248*^9, 3.9461872843092823`*^9}, 3.946187365054121*^9, {
   3.946187480278492*^9, 3.9461874874540024`*^9}, 3.9461880462086487`*^9, {
   3.9461881054797783`*^9, 3.9461881291423397`*^9}, {3.946188268454359*^9, 
   3.9461883008316956`*^9}, {3.94618835627853*^9, 3.946188455318756*^9}, 
   3.946257761266403*^9, {3.946258916015583*^9, 3.94625896478343*^9}, {
   3.946259615877109*^9, 3.946259655534961*^9}, {3.947132891348004*^9, 
   3.947132924188181*^9}, {3.9471329718839912`*^9, 3.9471329845888424`*^9}, {
   3.947133025988367*^9, 3.94713303106756*^9}, {3.9471334511324472`*^9, 
   3.94713348841169*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"806c98e7-c027-de46-8fc2-cc2eda959f64"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Cyclic quadrilateral routines", "Subsection",
 CellChangeTimes->{{3.945509919017998*^9, 3.945509932600797*^9}, {
  3.947162988550743*^9, 
  3.9471629928866825`*^9}},ExpressionUUID->"40e5692f-48f3-024d-af81-\
1a5914b0813b"],

Cell[CellGroupData[{

Cell["Circumcenter of a cyclic quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.945610802689909*^9, 3.945610812713859*^9}, {3.9456119081446075`*^9, 
  3.9456119094484024`*^9}},ExpressionUUID->"9332bfd4-b794-9542-bea9-\
284a11b178c6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CircumcenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Circuncentro", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
   3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
   3.9455136200666037`*^9}, {3.94561082469837*^9, 3.94561088310631*^9}, 
   3.94561179568902*^9, {3.945611920705227*^9, 3.945611942711619*^9}, 
   3.945616284586939*^9, 3.946652944770241*^9},
 CellLabel->"In[44]:=",ExpressionUUID->"5bc10ce3-9329-a946-86e7-d45107084797"]
}, Closed]],

Cell[CellGroupData[{

Cell["Anticenter of a cyclic quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.945610802689909*^9, 
  3.945610812713859*^9}},ExpressionUUID->"4a989280-28db-ca4e-bb0b-\
101f688af051"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvV1sU1f6/7t1zs258MXxZS4icRRZygVShaxIJwhV8UUQyFKCQFYUiCwb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    "], {{0, 470.71698113207543`}, {687.3962264150942, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.}],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->{687.3962264150942, 470.71698113207543`},
  PlotRange->{{0, 687.3962264150942}, {0, 470.71698113207543`}}]], "Text",
 CellChangeTimes->{3.946004699225712*^9, 3.946093819523939*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"113413b2-0b67-2b41-9e95-6ce395a68d94"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "4", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945615970386856*^9, 3.945615990738682*^9}, {
  3.945616055354908*^9, 3.945616056555292*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"80d07db2-b412-a249-8575-62ea6579cc8c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Det", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Recta", "[", 
       RowBox[{"ptA", ",", "ptE"}], "]"}], ",", 
      RowBox[{"Recta", "[", 
       RowBox[{"ptB", ",", "ptF"}], "]"}], ",", 
      RowBox[{"Recta", "[", 
       RowBox[{"ptC", ",", "ptG"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"cyclic", "==", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.945616063892462*^9, 3.94561615265847*^9}, 
   3.945616195998407*^9, {3.945616235402563*^9, 3.945616239194622*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"77841308-7f6b-cd46-a7ee-3ab0abd88dc2"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.945616132242279*^9, 3.9456161534983864`*^9}, 
   3.945616239883318*^9, 3.946004699315471*^9, 3.94609382722101*^9, 
   3.94628605964624*^9, 3.946286115022316*^9, 3.9463041366547737`*^9, 
   3.9463542991639366`*^9, 3.946641450487358*^9, 3.946651644201889*^9, 
   3.94666495833173*^9, 3.946704343778169*^9, 3.9470095409741*^9, 
   3.9470458183663616`*^9, 3.947163230856423*^9, 3.9471715489457254`*^9, 
   3.947266761899399*^9, 3.9472674111953506`*^9, 3.947569096234514*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"bb340b07-23c9-e544-8120-b1430002d10b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Det", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Recta", "[", 
       RowBox[{"ptA", ",", "ptE"}], "]"}], ",", 
      RowBox[{"Recta", "[", 
       RowBox[{"ptB", ",", "ptF"}], "]"}], ",", 
      RowBox[{"Recta", "[", 
       RowBox[{"ptD", ",", "ptH"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"cyclic", "==", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.94561616454653*^9, 3.945616176514675*^9}, 
   3.945616209284635*^9, {3.945616251434223*^9, 3.94561625544273*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"50b1474a-8391-ca4a-aad2-5206c808fb4f"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.9456161774445515`*^9, 3.945616256355671*^9, 
  3.946004699341404*^9, 3.946093827246943*^9, 3.9462860597190437`*^9, 
  3.946286115044258*^9, 3.946304136680708*^9, 3.946354299188868*^9, 
  3.946641450515772*^9, 3.946651644225818*^9, 3.9466649583586617`*^9, 
  3.9467043438031025`*^9, 3.947009541000035*^9, 3.947045818392288*^9, 
  3.9471632309232426`*^9, 3.947171549013541*^9, 3.947266761907385*^9, 
  3.947267411202332*^9, 3.9475690962424984`*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"7b72ddf0-a20a-e24f-897b-aa31de62e8be"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Medio", "[", 
    RowBox[{"P", ",", 
     RowBox[{"Ortocentro", "[", 
      RowBox[{"{", 
       RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
   3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
   3.9455136200666037`*^9}, {3.94561082469837*^9, 3.94561088310631*^9}, 
   3.94561179568902*^9, 3.946652955754562*^9},
 CellLabel->"In[48]:=",ExpressionUUID->"448ea2bb-3258-a841-a2d3-d7177e41cebf"]
}, Closed]],

Cell[CellGroupData[{

Cell["Centrocenter of a cyclic quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.945610802689909*^9, 3.945610812713859*^9}, {3.945611043737335*^9, 
  3.945611045361271*^9}},ExpressionUUID->"6221cf63-919d-e141-8412-\
466cad561c91"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvQ1wVGd673mym9rdSqlqV9lkUl0JG3IVZTV7ufEwSk8FD5nbqhu0zOgO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    "], {{0, 186.79245283018867`}, {724.0754716981131, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{724.0754716981131, 186.79245283018867`},
  PlotRange->{{0, 724.0754716981131}, {0, 186.79245283018867`}}]], "Text",
 CellChangeTimes->{3.94561131365608*^9, 3.946093845394991*^9},
 CellLabel->"In[50]:=",ExpressionUUID->"56df0d81-b84a-0a40-8935-622d3a9520bb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945615970386856*^9, 3.945615990738682*^9}, {
  3.945616055354908*^9, 3.945616056555292*^9}, {3.945616329113766*^9, 
  3.9456163297459545`*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"2a84e9eb-3b52-7d4c-8269-c5737e1783b0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sustituirxyz", "[", 
    RowBox[{
     RowBox[{"CircunferenciaTresPuntos", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG"}], "}"}], "]"}], ",", "ptH"}], 
    "]"}], ",", 
   RowBox[{"cyclic", "==", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.945616345620476*^9, 3.9456164106663303`*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"c59ea1e9-aaa1-ba42-8ac2-a180175f33d0"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.945616363395457*^9, 3.945616411439913*^9}, 
   3.946004699418197*^9, 3.9460938517686424`*^9, 3.946286128815033*^9, 
   3.94630413672262*^9, 3.946354299225767*^9, 3.946641450558687*^9, 
   3.94665164426383*^9, 3.946664958394562*^9, 3.946704343842997*^9, 
   3.947009541038946*^9, 3.947045818433208*^9, 3.947163230958145*^9, 
   3.947171549053409*^9, 3.94726676196822*^9, 3.947267411258182*^9, 
   3.9475690963043785`*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"66e6c993-6566-6043-bf9c-d63437e94735"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CentrocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"G1", ",", "G2", ",", "G3", ",", "G4"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G1", ",", "G2", ",", "G3", ",", "G4"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Baricentro", "[", "#", "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Q", ",", "R", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "R", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "Q", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "Q", ",", "R"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"G1", ",", "G2", ",", "G3"}], "}"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
   3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
   3.9455136200666037`*^9}, {3.94561082469837*^9, 3.94561088310631*^9}, {
   3.945611048795094*^9, 3.945611225281727*^9}, {3.945611707609211*^9, 
   3.945611722193455*^9}, 3.946652966770469*^9},
 CellLabel->"In[51]:=",ExpressionUUID->"58f5683c-eea5-5f4d-908b-138ff9f5786b"]
}, Closed]],

Cell[CellGroupData[{

Cell["Orthocenter of a cyclic quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.945610802689909*^9, 3.945610812713859*^9}, {3.945611043737335*^9, 
  3.945611045361271*^9}, {3.94561156951313*^9, 
  3.945611571897038*^9}},ExpressionUUID->"27f808e6-e579-8044-bb27-\
905ebef0af91"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnX9sU2ea7w0UkqCoupn/LC33tspmylbcqXpTaycVMzfRHaJWaHFLFSEo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    "], {{0, 148.75471698113208`}, {522.3396226415094, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.}],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->{522.3396226415094, 148.75471698113208`},
  PlotRange->{{0, 522.3396226415094}, {0, 148.75471698113208`}}]], "Text",
 CellChangeTimes->{3.946004699433159*^9, 3.946093874356119*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"b9f0a34c-bb41-5b40-8075-20f44c1ed2ab"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "4", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945615970386856*^9, 3.945615990738682*^9}, {
  3.945616055354908*^9, 3.945616056555292*^9}, {3.945616329113766*^9, 
  3.9456163297459545`*^9}, {3.945616452417559*^9, 3.945616453058086*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"289e036b-59cc-294d-8968-9f3882987b07"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sustituirxyz", "[", 
    RowBox[{
     RowBox[{"CircunferenciaTresPuntos", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG"}], "}"}], "]"}], ",", "ptH"}], 
    "]"}], ",", 
   RowBox[{"cyclic", "==", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.945616345620476*^9, 3.9456164106663303`*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"5cb44932-662b-c34f-9d5e-9a4f33e7d9e5"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.945616363395457*^9, 3.945616411439913*^9}, 
   3.9456164568814487`*^9, 3.946004700309868*^9, 3.946093879603981*^9, 
   3.946286139083276*^9, 3.946304137587335*^9, 3.946354300080492*^9, 
   3.946641451454262*^9, 3.946651645133545*^9, 3.946664959321087*^9, 
   3.946704344703785*^9, 3.947009541908619*^9, 3.947045819301859*^9, 
   3.947163231892654*^9, 3.947171549989996*^9, 3.9472667620220757`*^9, 
   3.947267411306055*^9, 3.947569096352249*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"c9df0138-2546-cb49-9ada-122f380454b6"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"OrthocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"H1", ",", "H2", ",", "H3", ",", "H4"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "H2", ",", "H3", ",", "H4"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Ortocentro", "[", "#", "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Q", ",", "R", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "R", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "Q", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "Q", ",", "R"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "H2", ",", "H3"}], "}"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945611735225509*^9, 3.945611777816695*^9}, 
   3.946652975162092*^9},
 CellLabel->"In[54]:=",ExpressionUUID->"b3d30327-18b8-3e47-8ce7-7916c293687d"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell["Properties ", "Section",
 CellChangeTimes->{{3.9464385601246834`*^9, 3.9464385707657948`*^9}, {
  3.9464417172462025`*^9, 
  3.946441726397751*^9}},ExpressionUUID->"2609bf4c-7f5c-314e-a744-\
f86d4be283dd"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvV9MW9e2/+v75+E++OHymAekXCFLXClSFSGkmyjaggeiEyEBaoRQUmQZ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    "], {{0, 332.1509433962264}, {723.3962264150942, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{723.3962264150942, 332.1509433962264},
  PlotRange->{{0, 723.3962264150942}, {0, 332.1509433962264}}]], "Text",
 CellChangeTimes->{
  3.9472664775156307`*^9},ExpressionUUID->"025519cf-cc24-ac4a-b1b8-\
5f6eea41e8c2"],

Cell[CellGroupData[{

Cell["X (6)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, {3.9472664882721004`*^9, 
   3.947266488328705*^9}},ExpressionUUID->"05a1e3c3-6472-f140-9524-\
e2a0b3b33a84"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "6", "]"}]}]], "Input",
 CellChangeTimes->{
  3.9471632378229856`*^9, {3.9472668120571175`*^9, 3.9472668121366463`*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"4c28bf26-a6ce-8a42-b991-8ad29b361320"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "4"]}], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "4"]}], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "4"]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["a", "2"], ",", 
     SuperscriptBox["b", "2"], ",", 
     SuperscriptBox["c", "2"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9471632384884577`*^9, 3.9472668132269993`*^9},
 CellLabel->"Out[65]=",ExpressionUUID->"9fc5228c-c14f-9d47-8509-abbeabec36d2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["anti[ABCD] = dp (ABCD) ", "Subsubsection",
 CellChangeTimes->{{3.946706976860153*^9, 
  3.946706992833111*^9}},ExpressionUUID->"d1205e47-b2b2-8049-873f-\
d577d1935580"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.946707021017731*^9, 3.946707056313673*^9}, 
   3.9472668158490314`*^9},
 CellLabel->"In[66]:=",ExpressionUUID->"77944f63-9d63-b443-b520-762d1ad7196a"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9467070576887913`*^9, 3.94726682222633*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"761abad9-bad4-c147-b063-c765c2efdfd5"],

Cell[CellGroupData[{

Cell["dp (ABCD) = dp (EFGH)", "Subsubsection",
 CellChangeTimes->{{3.946706980171034*^9, 3.94670699700077*^9}, {
  3.946707201032797*^9, 3.9467072021935678`*^9}, {3.946707270648503*^9, 
  3.946707271568043*^9}},ExpressionUUID->"c1c83106-6478-7a43-8256-\
38a15359fc1e"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.946707144481069*^9, 3.9467071762171497`*^9}, {
   3.9467072081056027`*^9, 3.946707218025624*^9}, 3.947266847280876*^9},
 CellLabel->"In[67]:=",ExpressionUUID->"7dd0efcc-831d-2146-bcde-2d5206d1b796"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9467072098595047`*^9, 3.9472668486352386`*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"0cd8eb1a-1805-3645-83a5-54e1e67fc719"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (24)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, {3.9472664882721004`*^9, 3.947266488328705*^9}, {
   3.947266890360256*^9, 
   3.947266890792448*^9}},ExpressionUUID->"84fb6ddf-5941-1646-a85e-\
05e2cdfcccd9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "24", "]"}]}]], "Input",
 CellChangeTimes->{
  3.9471632378229856`*^9, {3.9472668120571175`*^9, 3.9472668121366463`*^9}, {
   3.9472668958888016`*^9, 3.947266896521101*^9}},
 CellLabel->"In[68]:=",ExpressionUUID->"4f0f7fb9-3495-8046-973c-54dce4d78dcd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
        SuperscriptBox["c", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.9471632384884577`*^9, 3.9472668132269993`*^9, 
  3.947266897087126*^9},
 CellLabel->"Out[68]=",ExpressionUUID->"89dc9c57-5392-2a48-b4f1-f0a625cdc6f1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["anti[ABCD] = dp (ABCD) ", "Subsubsection",
 CellChangeTimes->{{3.946706976860153*^9, 
  3.946706992833111*^9}},ExpressionUUID->"f891fb34-6e50-314e-814a-\
f6176168a751"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.946707021017731*^9, 3.946707056313673*^9}, 
   3.9472668158490314`*^9},
 CellLabel->"In[69]:=",ExpressionUUID->"bac444e4-d3c7-c44a-b5df-bf4a9b7254fb"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9467070576887913`*^9, 3.94726682222633*^9, 
  3.9472669049870567`*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"f411f88e-33d5-4543-b52f-fa5d8a6e2adb"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["dp (ABCD) = dp (EFGH)", "Subsubsection",
 CellChangeTimes->{{3.946706980171034*^9, 3.94670699700077*^9}, {
  3.946707201032797*^9, 3.9467072021935678`*^9}, {3.946707270648503*^9, 
  3.946707271568043*^9}},ExpressionUUID->"de52ecc3-3d66-ed47-b247-\
e97eda5cd9ff"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.946707144481069*^9, 3.9467071762171497`*^9}, {
   3.9467072081056027`*^9, 3.946707218025624*^9}, 3.947266847280876*^9},
 CellLabel->"In[70]:=",ExpressionUUID->"9dc6356e-d9c6-6346-924a-3f29d80b10de"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9467072098595047`*^9, 3.9472668486352386`*^9, 
  3.9472669071388435`*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"bf8071c8-a6af-b04b-9a1a-735b6f21ec9e"],

Cell[CellGroupData[{

Cell["QA-P9=persp[ABCD, GHEF]", "Subsubsection",
 CellChangeTimes->{{3.9467075353152523`*^9, 3.946707536281472*^9}, {
  3.9467075930568504`*^9, 3.946707593112597*^9}, {3.946723557578316*^9, 
  3.9467235609460382`*^9}},ExpressionUUID->"89bf3bde-9ab7-3642-bb38-\
fedbc05ebf1d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"PerspectiveQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptG", ",", "ptH", ",", "ptE", ",", "ptF"}], "}"}]}], "]"}], 
   ",", "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.946707555304905*^9, 3.9467076399999943`*^9}, {
  3.9472669393212986`*^9, 3.9472669394565907`*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"1cd050c1-6e1a-6243-90a4-a43e1a140b08"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.946707600990347*^9, 3.94670764185747*^9}, 
   3.9467077189023967`*^9, 3.946707976991846*^9, 3.946723572696913*^9, 
   3.947266946535755*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"6e29d6eb-bd5d-4b43-8cab-1c4e662566be"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ptP", "=", 
   RowBox[{"PerspectorConABC", "[", 
    RowBox[{"{", 
     RowBox[{"ptG", ",", "ptH", ",", "ptE"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"findQACenter", "[", 
  RowBox[{"ptP", ",", "cortho"}], "]"}]}], "Input",
 CellChangeTimes->{{3.946707720690773*^9, 3.94670774634412*^9}, {
  3.946707932448303*^9, 3.946707933888151*^9}},
 CellLabel->"In[72]:=",ExpressionUUID->"af370f1a-24f6-be40-bddb-9b5981a4d4f8"],

Cell[BoxData["\<\"QA-P9\"\>"], "Output",
 CellChangeTimes->{
  3.946707747230156*^9, {3.9467079745525684`*^9, 3.946707982658186*^9}, 
   3.946723578417309*^9, 3.9472669584004116`*^9},
 CellLabel->"Out[73]=",ExpressionUUID->"7c78ffe1-954e-454f-b860-a306ab518f1e"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (25)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, {3.9472664882721004`*^9, 3.947266488328705*^9}, {
   3.947266890360256*^9, 3.947266890792448*^9}, {3.94726699347262*^9, 
   3.947266993536871*^9}},ExpressionUUID->"1d0e9881-b171-4a46-a2b2-\
411ef3f6b270"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "25", "]"}]}]], "Input",
 CellChangeTimes->{
  3.9471632378229856`*^9, {3.9472668120571175`*^9, 3.9472668121366463`*^9}, {
   3.9472668958888016`*^9, 3.947266896521101*^9}, {3.947266999208412*^9, 
   3.9472669992405167`*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"f341e008-d46f-1b45-aa33-57c075406c4a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9471632384884577`*^9, 3.9472668132269993`*^9, 
  3.947266897087126*^9, 3.9472670035493603`*^9},
 CellLabel->"Out[74]=",ExpressionUUID->"4b72ec0f-519b-ac49-8abc-8ad4b6f15df3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["anti[ABCD] = dp (ABCD) ", "Subsubsection",
 CellChangeTimes->{{3.946706976860153*^9, 
  3.946706992833111*^9}},ExpressionUUID->"11b204e6-f881-e543-8dad-\
ccf4ca9c7d34"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.946707021017731*^9, 3.946707056313673*^9}, 
   3.9472668158490314`*^9},
 CellLabel->"In[75]:=",ExpressionUUID->"d0346b2e-9ddf-4946-bb08-4c0cc1da8ee2"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9467070576887913`*^9, 3.94726682222633*^9, 
  3.9472669049870567`*^9, 3.9472670095148163`*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"d0aee9b4-492a-b845-92bf-fa82ed88805f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["dp (ABCD) = dp (EFGH)", "Subsubsection",
 CellChangeTimes->{{3.946706980171034*^9, 3.94670699700077*^9}, {
  3.946707201032797*^9, 3.9467072021935678`*^9}, {3.946707270648503*^9, 
  3.946707271568043*^9}},ExpressionUUID->"f67cd588-14a6-8c48-ae7c-\
32eac261ff26"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.946707144481069*^9, 3.9467071762171497`*^9}, {
   3.9467072081056027`*^9, 3.946707218025624*^9}, 3.947266847280876*^9},
 CellLabel->"In[76]:=",ExpressionUUID->"b1b19e21-b284-be42-8601-b45ff6370140"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9467072098595047`*^9, 3.9472668486352386`*^9, 
  3.9472669071388435`*^9, 3.9472670112188454`*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"d97fa834-1034-e44c-8402-1562d4254167"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (51)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, {3.9472664882721004`*^9, 3.947266488328705*^9}, {
   3.947266890360256*^9, 3.947266890792448*^9}, {3.94726699347262*^9, 
   3.947266993536871*^9}, {3.9472670512399006`*^9, 
   3.9472670524488316`*^9}},ExpressionUUID->"f422df93-e1ea-ab45-b3d4-\
434ce64bd1ca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "51", "]"}]}]], "Input",
 CellChangeTimes->{
  3.9471632378229856`*^9, {3.9472668120571175`*^9, 3.9472668121366463`*^9}, {
   3.9472668958888016`*^9, 3.947266896521101*^9}, {3.947266999208412*^9, 
   3.9472669992405167`*^9}, {3.947267060000368*^9, 3.9472670604725876`*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"8a42e4f1-503f-9342-a3a5-d904ad10fdb0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "6"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
           SuperscriptBox["c", "3"]}], ")"}], "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "8"], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         SuperscriptBox["c", "6"]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "6"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
         SuperscriptBox["c", "3"]}], ")"}], "2"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "6"], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "2"]}]}], ")"}], "2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         SuperscriptBox["c", "4"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.9471632384884577`*^9, 3.9472668132269993`*^9, 
  3.947266897087126*^9, 3.9472670035493603`*^9, 3.947267061269455*^9, 
  3.947267099838541*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"f27bedc9-80b3-004d-aa1f-75abcf3b5632"]
}, Open  ]],

Cell[CellGroupData[{

Cell["anti[ABCD] = dp[ABCD]  ", "Subsubsection",
 CellChangeTimes->{{3.946455475830339*^9, 3.946455478286655*^9}, 
   3.946459038326063*^9, {3.9464592755826244`*^9, 3.9464592769669704`*^9}, {
   3.9467231315639515`*^9, 
   3.946723138986958*^9}},ExpressionUUID->"a1468a1e-f05d-0444-8654-\
b8816172c043"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.94670562716325*^9, 3.946705669762529*^9}, {
   3.946705703747917*^9, 3.946705705034683*^9}, {3.946723187171833*^9, 
   3.94672321343519*^9}, 3.947267095944092*^9},
 CellLabel->"In[79]:=",ExpressionUUID->"c2b8f642-467b-1146-b824-9c8e450857d8"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467057067847385`*^9, {3.946723195174942*^9, 3.946723214119566*^9}, 
   3.9472671093220882`*^9},
 CellLabel->"Out[79]=",ExpressionUUID->"5cf099bb-3adf-a846-aaca-dcc9bdd7ea76"],

Cell[CellGroupData[{

Cell["anti[ABCD] = stein[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946459029088383*^9, 
  3.9464590520700207`*^9}},ExpressionUUID->"01cb555a-fbc9-434f-8e99-\
fb9fee8a5734"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.9467062678657017`*^9, 3.946706303786476*^9}, 
   3.947267128600466*^9},
 CellLabel->"In[80]:=",ExpressionUUID->"e4698304-029c-604e-b10a-7b7bc7067edb"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946706381229746*^9, 3.946723327056368*^9, 
  3.9472671404907513`*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"9cd9855b-42c0-5442-aba7-8e486df4e537"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (52)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, {3.9472664882721004`*^9, 3.947266488328705*^9}, {
   3.947266890360256*^9, 3.947266890792448*^9}, {3.94726699347262*^9, 
   3.947266993536871*^9}, {3.9472670512399006`*^9, 3.9472670524488316`*^9}, {
   3.9472671704558697`*^9, 
   3.947267170463854*^9}},ExpressionUUID->"07974ee4-7528-1c4a-880b-\
2e93e43f2a00"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "52", "]"}]}]], "Input",
 CellChangeTimes->{
  3.9471632378229856`*^9, {3.9472668120571175`*^9, 3.9472668121366463`*^9}, {
   3.9472668958888016`*^9, 3.947266896521101*^9}, {3.947266999208412*^9, 
   3.9472669992405167`*^9}, {3.947267060000368*^9, 3.9472670604725876`*^9}, {
   3.947267178248844*^9, 3.9472671783442135`*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"00876137-16db-0548-93bb-af13054a2e63"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
           SuperscriptBox["c", "3"]}], ")"}], "2"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "12"], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "10"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "8"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         SuperscriptBox["c", "8"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "8"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "10"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "10"], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "8"], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "10"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
         SuperscriptBox["c", "3"]}], ")"}], "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "8"], "-", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.9471632384884577`*^9, 3.9472668132269993`*^9, 
  3.947266897087126*^9, 3.9472670035493603`*^9, 3.947267061269455*^9, 
  3.947267099838541*^9, 3.9472671794393787`*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"7e775ee2-0b33-c647-9e3b-8fbccc197e08"]
}, Open  ]],

Cell[CellGroupData[{

Cell["anti[ABCD] = dp[ABCD]  ", "Subsubsection",
 CellChangeTimes->{{3.946455475830339*^9, 3.946455478286655*^9}, 
   3.946459038326063*^9, {3.9464592755826244`*^9, 3.9464592769669704`*^9}, {
   3.9467231315639515`*^9, 
   3.946723138986958*^9}},ExpressionUUID->"8f59f247-68ea-f24c-ae71-\
a9ae07bf2500"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.94670562716325*^9, 3.946705669762529*^9}, {
   3.946705703747917*^9, 3.946705705034683*^9}, {3.946723187171833*^9, 
   3.94672321343519*^9}, 3.947267095944092*^9},
 CellLabel->"In[82]:=",ExpressionUUID->"405ebf02-e92e-6d4a-bb88-15a0374e024b"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467057067847385`*^9, {3.946723195174942*^9, 3.946723214119566*^9}, 
   3.9472671093220882`*^9, 3.9472671812338085`*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"5c11986b-1bb6-644e-830f-a3fab1d658d1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["anti[ABCD] = stein[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946459029088383*^9, 
  3.9464590520700207`*^9}},ExpressionUUID->"6f2490e9-3c09-6b4f-8258-\
2195e938ceed"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.9467062678657017`*^9, 3.946706303786476*^9}, 
   3.947267128600466*^9},
 CellLabel->"In[83]:=",ExpressionUUID->"7db70e08-35ce-884c-b6ae-216252fe4b1d"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946706381229746*^9, 3.946723327056368*^9, 
  3.9472671404907513`*^9, 3.9472671842324123`*^9},
 CellLabel->"Out[83]=",ExpressionUUID->"deb495be-6c63-144e-942e-09a57d34d942"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (53)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, {3.9472664882721004`*^9, 3.947266488328705*^9}, {
   3.947266890360256*^9, 3.947266890792448*^9}, {3.94726699347262*^9, 
   3.947266993536871*^9}, {3.9472670512399006`*^9, 3.9472670524488316`*^9}, {
   3.947267202704626*^9, 
   3.9472672027283726`*^9}},ExpressionUUID->"9b504da3-ad0b-f64f-a902-\
51b21c5b7b62"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "53", "]"}]}]], "Input",
 CellChangeTimes->{
  3.9471632378229856`*^9, {3.9472668120571175`*^9, 3.9472668121366463`*^9}, {
   3.9472668958888016`*^9, 3.947266896521101*^9}, {3.947266999208412*^9, 
   3.9472669992405167`*^9}, {3.947267060000368*^9, 3.9472670604725876`*^9}, {
   3.9472672076169395`*^9, 3.947267207688242*^9}},
 CellLabel->"In[84]:=",ExpressionUUID->"47cbd477-f891-4c4e-8903-2c8bcf16445e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
           SuperscriptBox["c", "3"]}], ")"}], "2"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "8"], "-", 
          RowBox[{
           SuperscriptBox["b", "6"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["b", "4"], " ", 
           SuperscriptBox["c", "4"]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "6"]}], "+", 
          SuperscriptBox["c", "8"], "-", 
          RowBox[{
           SuperscriptBox["a", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "4"], "+", 
             RowBox[{"6", " ", 
              SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "6"], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["b", "4"], " ", 
              SuperscriptBox["c", "2"]}], "-", 
             RowBox[{"3", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "4"]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ")"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           SuperscriptBox["c", "4"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "8"], "+", 
          SuperscriptBox["b", "8"], "-", 
          RowBox[{
           SuperscriptBox["b", "6"], " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "6"]}], "+", 
          SuperscriptBox["c", "8"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "4"]}], "+", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{"6", " ", 
              SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "6"], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["b", "4"], " ", 
              SuperscriptBox["c", "2"]}], "-", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "4"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ")"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "6"]}], "+", 
        SuperscriptBox["c", "8"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "4"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "6"], "+", 
          RowBox[{
           SuperscriptBox["c", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "4"], "+", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ")"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.9471632384884577`*^9, 3.9472668132269993`*^9, 
  3.947266897087126*^9, 3.9472670035493603`*^9, 3.947267061269455*^9, 
  3.947267099838541*^9, 3.94726720846245*^9},
 CellLabel->"Out[84]=",ExpressionUUID->"63d89bfc-46dd-a44f-98fe-638702e43366"]
}, Open  ]],

Cell[CellGroupData[{

Cell["anti[ABCD] = dp[ABCD]  ", "Subsubsection",
 CellChangeTimes->{{3.946455475830339*^9, 3.946455478286655*^9}, 
   3.946459038326063*^9, {3.9464592755826244`*^9, 3.9464592769669704`*^9}, {
   3.9467231315639515`*^9, 
   3.946723138986958*^9}},ExpressionUUID->"e79ad7ef-de4b-7b4d-bc28-\
99d8181d21da"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.94670562716325*^9, 3.946705669762529*^9}, {
   3.946705703747917*^9, 3.946705705034683*^9}, {3.946723187171833*^9, 
   3.94672321343519*^9}, 3.947267095944092*^9},
 CellLabel->"In[85]:=",ExpressionUUID->"9616f8a6-2a43-3d49-86a1-6cc63d536e7d"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467057067847385`*^9, {3.946723195174942*^9, 3.946723214119566*^9}, 
   3.9472671093220882`*^9, 3.9472672105379524`*^9},
 CellLabel->"Out[85]=",ExpressionUUID->"914e89cd-6037-144c-a685-167eded2aafe"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["anti[ABCD] = stein[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946459029088383*^9, 
  3.9464590520700207`*^9}},ExpressionUUID->"35d4d948-3b1f-6f41-939f-\
4d79fc020836"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.9467062678657017`*^9, 3.946706303786476*^9}, 
   3.947267128600466*^9},
 CellLabel->"In[86]:=",ExpressionUUID->"3165c482-166f-1540-989a-45cccd943c00"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946706381229746*^9, 3.946723327056368*^9, 
  3.9472671404907513`*^9, 3.9472672175845394`*^9},
 CellLabel->"Out[86]=",ExpressionUUID->"36e17bfa-badb-1d40-a44d-1471c1a44359"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (68)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, {3.9472664882721004`*^9, 3.947266488328705*^9}, 
   3.947267254192007*^9},ExpressionUUID->"3d5448e9-c81e-564a-98d0-\
a24160c89bcd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "68", "]"}]}]], "Input",
 CellChangeTimes->{
  3.9471632378229856`*^9, {3.9472668120571175`*^9, 3.9472668121366463`*^9}, 
   3.9472672601684284`*^9},
 CellLabel->"In[87]:=",ExpressionUUID->"b16e0ab5-ae31-9540-819d-a0eb9c99b79b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "10"], "-", 
          RowBox[{
           SuperscriptBox["a", "8"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{"5", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              SuperscriptBox["b", "4"]}], "+", 
             RowBox[{"6", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{"5", " ", 
              SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "6"]}], "+", 
             RowBox[{"5", " ", 
              SuperscriptBox["b", "4"], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{"6", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "4"]}], "+", 
             RowBox[{"5", " ", 
              SuperscriptBox["c", "6"]}]}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "8"], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["b", "6"], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             SuperscriptBox["c", "8"]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "8"], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["b", "6"], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["b", "4"], " ", 
              SuperscriptBox["c", "4"]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "6"]}], "+", 
             RowBox[{"5", " ", 
              SuperscriptBox["c", "8"]}]}], ")"}]}]}], ")"}]}], ")"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "8"], "+", 
          SuperscriptBox["b", "8"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["b", "6"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["b", "4"], " ", 
           SuperscriptBox["c", "4"]}], "-", 
          SuperscriptBox["c", "8"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["b", "6"]}], "+", 
             RowBox[{
              SuperscriptBox["b", "4"], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "4"]}], "+", 
             SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}], ")"}]}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "10"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["a", "8"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "8"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["c", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["c", "4"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "4"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{"6", " ", 
              SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ")"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["b", "2"]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ")"}]}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9471632384884577`*^9, 3.9472668132269993`*^9, 
  3.947267260773142*^9},
 CellLabel->"Out[87]=",ExpressionUUID->"8d6345da-e659-ad4d-a698-256aace67093"]
}, Open  ]],

Cell[CellGroupData[{

Cell["[ABCD] = [EHGF]  ", "Subsubsection",
 CellChangeTimes->{{3.9467207975769677`*^9, 
  3.946720805056477*^9}},ExpressionUUID->"bde8acd8-aac5-954f-8796-\
7b4eb0aedb55"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"AreaQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], "-", 
   RowBox[{"AreaQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptH", ",", "ptG", ",", "ptF"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.946455235060501*^9, 3.9464552356199303`*^9}, {
   3.946720776206087*^9, 3.946720790191031*^9}, {3.947267320192198*^9, 
   3.9472673203518753`*^9}},
 CellLabel->"In[90]:=",ExpressionUUID->"bd0d9a8a-64d8-204d-9d26-d0ec92fa4a69"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.946439747579574*^9, 3.946439928198509*^9, 3.946445011755708*^9, 
   3.946445596813852*^9, 3.9464457083955994`*^9, 3.9464507719139843`*^9, 
   3.9464511511305084`*^9, {3.946451225001627*^9, 3.946451284311329*^9}, 
   3.9464535168114395`*^9, {3.946455237684889*^9, 3.946455259000507*^9}, 
   3.946705493113365*^9, 3.946720808329685*^9, 3.94726732123403*^9},
 CellLabel->"Out[90]=",ExpressionUUID->"f6a93f63-e9d0-9f42-a089-96d5dbe76da9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["anti[ABCD] = dp (ABCD) ", "Subsubsection",
 CellChangeTimes->{{3.946706976860153*^9, 
  3.946706992833111*^9}},ExpressionUUID->"068ffa8d-2727-874b-a5fd-\
0de3e4d801ad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.946707021017731*^9, 3.946707056313673*^9}, 
   3.9472668158490314`*^9},
 CellLabel->"In[88]:=",ExpressionUUID->"3149357e-8d78-a34d-b4ab-e72521bd2a75"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9467070576887913`*^9, 3.94726682222633*^9, 
  3.94726727458638*^9},
 CellLabel->"Out[88]=",ExpressionUUID->"bb783221-a76e-344e-8c49-3c557449eadf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["dp (ABCD) = dp (EFGH)", "Subsubsection",
 CellChangeTimes->{{3.946706980171034*^9, 3.94670699700077*^9}, {
  3.946707201032797*^9, 3.9467072021935678`*^9}, {3.946707270648503*^9, 
  3.946707271568043*^9}},ExpressionUUID->"a6dbe2b9-6198-f74c-8a86-\
370d5fefaf9b"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.946707144481069*^9, 3.9467071762171497`*^9}, {
   3.9467072081056027`*^9, 3.946707218025624*^9}, 3.947266847280876*^9},
 CellLabel->"In[89]:=",ExpressionUUID->"828c3d5d-2624-8648-beac-dc4c2cc5b790"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9467072098595047`*^9, 3.9472668486352386`*^9, 
  3.9472672771387615`*^9},
 CellLabel->"Out[89]=",ExpressionUUID->"f9e4b402-c6e3-7e40-97ea-780775f2ee82"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (128)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, {3.9472664882721004`*^9, 3.947266488328705*^9}, 
   3.947267254192007*^9, {3.9472674918473606`*^9, 
   3.9472674920401783`*^9}},ExpressionUUID->"49a4c270-beaa-2248-9bbf-\
bd37eb7d3d40"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "128", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9472675055282383`*^9, 3.947267518768564*^9}},
 CellLabel->
  "In[146]:=",ExpressionUUID->"09dd261c-66df-e24c-98a8-2f096992e6d2"],

Cell["anti[ABCD] = dp[ABCD]  ", "Subsubsection",
 CellChangeTimes->{{3.946455475830339*^9, 3.946455478286655*^9}, 
   3.946459038326063*^9, {3.9464592755826244`*^9, 3.9464592769669704`*^9}, {
   3.9467231315639515`*^9, 
   3.946723138986958*^9}},ExpressionUUID->"b406ab46-5abb-0f4b-b152-\
d528f720be6c"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.94670562716325*^9, 3.946705669762529*^9}, {
  3.946705703747917*^9, 3.946705705034683*^9}, {3.946723187171833*^9, 
  3.94672321343519*^9}, {3.9472675016819763`*^9, 3.947267526383997*^9}},
 CellLabel->
  "In[147]:=",ExpressionUUID->"c71db3fb-f123-3045-a07f-528ff4a289ad"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467057067847385`*^9, {3.946723195174942*^9, 3.946723214119566*^9}, 
   3.9472675289937096`*^9},
 CellLabel->
  "Out[147]=",ExpressionUUID->"0171ddd2-0226-4543-93f7-ded55aae0b61"],

Cell["anti[ABCD] = stein[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946459029088383*^9, 
  3.9464590520700207`*^9}},ExpressionUUID->"0154d8b4-24ca-de4b-b385-\
5a8671c03c8a"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.9467062678657017`*^9, 3.946706303786476*^9}, 
   3.947267556608343*^9},
 CellLabel->
  "In[148]:=",ExpressionUUID->"74c68244-de19-7541-b0b7-b40bb3c06673"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946706381229746*^9, 3.946723327056368*^9, 
  3.947267596599533*^9},
 CellLabel->
  "Out[148]=",ExpressionUUID->"98da4bd7-b22a-5542-8f97-2e8fff69ad83"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (129)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, {3.9472664882721004`*^9, 3.947266488328705*^9}, 
   3.947267254192007*^9, {3.9472674918473606`*^9, 3.9472674920401783`*^9}, {
   3.947267613591734*^9, 
   3.9472676136959095`*^9}},ExpressionUUID->"0a7d5382-e643-fd4e-9617-\
e8f9cc89a145"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "129", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9472675055282383`*^9, 3.947267518768564*^9}, {
  3.9472676232005997`*^9, 3.9472676232646008`*^9}},
 CellLabel->
  "In[149]:=",ExpressionUUID->"7925e5e1-57ab-f243-ab75-9940c6ab032b"],

Cell["anti[ABCD] = dp[ABCD]  ", "Subsubsection",
 CellChangeTimes->{{3.946455475830339*^9, 3.946455478286655*^9}, 
   3.946459038326063*^9, {3.9464592755826244`*^9, 3.9464592769669704`*^9}, {
   3.9467231315639515`*^9, 
   3.946723138986958*^9}},ExpressionUUID->"e840cb92-214f-bd42-a1d9-\
fce8036c620b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.94670562716325*^9, 3.946705669762529*^9}, {
  3.946705703747917*^9, 3.946705705034683*^9}, {3.946723187171833*^9, 
  3.94672321343519*^9}, {3.9472675016819763`*^9, 3.947267526383997*^9}},
 CellLabel->
  "In[150]:=",ExpressionUUID->"f06df217-915a-0045-b4a0-e662a3ffc09e"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467057067847385`*^9, {3.946723195174942*^9, 3.946723214119566*^9}, 
   3.9472675289937096`*^9, 3.947267626001854*^9},
 CellLabel->
  "Out[150]=",ExpressionUUID->"63558b11-a936-1f45-af59-883e3f8d793a"]
}, Open  ]],

Cell["anti[ABCD] = stein[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946459029088383*^9, 
  3.9464590520700207`*^9}},ExpressionUUID->"de3e84e7-2508-f541-a326-\
ecdd2638b9f8"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.9467062678657017`*^9, 3.946706303786476*^9}, 
   3.947267556608343*^9},
 CellLabel->
  "In[151]:=",ExpressionUUID->"19e34b30-1001-864c-b842-c1cdecd64e3b"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946706381229746*^9, 3.946723327056368*^9, 
  3.947267596599533*^9, 3.9472676653145733`*^9},
 CellLabel->
  "Out[151]=",ExpressionUUID->"12ed4bbb-3e57-6446-b858-6a04411ea275"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (130)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, {3.9472664882721004`*^9, 3.947266488328705*^9}, 
   3.947267254192007*^9, {3.9472674918473606`*^9, 3.9472674920401783`*^9}, {
   3.947267685216051*^9, 
   3.9472676852880726`*^9}},ExpressionUUID->"d32c02bb-4a12-0d49-816a-\
77e6e1a9cb2a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "130", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9472675055282383`*^9, 3.947267518768564*^9}, {
  3.947267690568966*^9, 3.947267698696913*^9}},
 CellLabel->
  "In[153]:=",ExpressionUUID->"a7d44694-1762-3444-99fc-17d6b1fb683f"],

Cell["anti[ABCD] = dp[ABCD]  ", "Subsubsection",
 CellChangeTimes->{{3.946455475830339*^9, 3.946455478286655*^9}, 
   3.946459038326063*^9, {3.9464592755826244`*^9, 3.9464592769669704`*^9}, {
   3.9467231315639515`*^9, 
   3.946723138986958*^9}},ExpressionUUID->"c8fdf9f2-14fc-3b4b-9140-\
3feef5c71092"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.94670562716325*^9, 3.946705669762529*^9}, {
  3.946705703747917*^9, 3.946705705034683*^9}, {3.946723187171833*^9, 
  3.94672321343519*^9}, {3.9472675016819763`*^9, 3.947267526383997*^9}},
 CellLabel->
  "In[154]:=",ExpressionUUID->"d415c4fa-33eb-014f-9877-6fe53ec76b3c"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467057067847385`*^9, {3.946723195174942*^9, 3.946723214119566*^9}, 
   3.9472675289937096`*^9, 3.9472677032665577`*^9},
 CellLabel->
  "Out[154]=",ExpressionUUID->"e1754135-42b8-0b40-952e-2ef6a0c61bbc"]
}, Open  ]],

Cell["anti[ABCD] = stein[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946459029088383*^9, 
  3.9464590520700207`*^9}},ExpressionUUID->"79863603-d67f-8441-93a9-\
b1fb9e839cc7"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.9467062678657017`*^9, 3.946706303786476*^9}, 
   3.947267556608343*^9},
 CellLabel->
  "In[155]:=",ExpressionUUID->"8af35b33-8550-704d-9585-9cd7e921a1e7"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946706381229746*^9, 3.946723327056368*^9, 
  3.947267596599533*^9, 3.9472677277642727`*^9},
 CellLabel->
  "Out[155]=",ExpressionUUID->"833b16b9-b3c5-584e-bad3-b94b000264d3"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (137)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, {3.9472664882721004`*^9, 3.947266488328705*^9}, 
   3.947267254192007*^9, {3.9472674918473606`*^9, 3.9472674920401783`*^9}, {
   3.947267763008116*^9, 
   3.9472677638160763`*^9}},ExpressionUUID->"83fd0638-3e1f-534d-8e29-\
883b8d834a68"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "137", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9472675055282383`*^9, 3.947267518768564*^9}, {
  3.94726776898526*^9, 3.947267774328766*^9}},
 CellLabel->
  "In[157]:=",ExpressionUUID->"330a0280-c4c1-9a4d-80cc-e975faf4c3b4"],

Cell["anti[ABCD] = dp[ABCD]  ", "Subsubsection",
 CellChangeTimes->{{3.946455475830339*^9, 3.946455478286655*^9}, 
   3.946459038326063*^9, {3.9464592755826244`*^9, 3.9464592769669704`*^9}, {
   3.9467231315639515`*^9, 
   3.946723138986958*^9}},ExpressionUUID->"794945fb-2ef7-3b42-8276-\
07ab91ce7c71"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.94670562716325*^9, 3.946705669762529*^9}, {
  3.946705703747917*^9, 3.946705705034683*^9}, {3.946723187171833*^9, 
  3.94672321343519*^9}, {3.9472675016819763`*^9, 3.947267526383997*^9}},
 CellLabel->
  "In[158]:=",ExpressionUUID->"4dd1e563-7850-b943-bbb0-fcc14529ef07"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467057067847385`*^9, {3.946723195174942*^9, 3.946723214119566*^9}, 
   3.9472675289937096`*^9, 3.947267778290674*^9},
 CellLabel->
  "Out[158]=",ExpressionUUID->"10881e94-f932-4547-b9fd-e47a30eaa064"]
}, Open  ]],

Cell["anti[ABCD] = stein[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946459029088383*^9, 
  3.9464590520700207`*^9}},ExpressionUUID->"97253f4f-f597-884d-ad63-\
bd6113e0a3d2"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.9467062678657017`*^9, 3.946706303786476*^9}, 
   3.947267556608343*^9},
 CellLabel->
  "In[159]:=",ExpressionUUID->"234a67dc-ceec-9349-92c2-0db4659dfd75"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946706381229746*^9, 3.946723327056368*^9, 
  3.947267596599533*^9, 3.947267788156336*^9},
 CellLabel->
  "Out[159]=",ExpressionUUID->"b031e191-b69f-a94d-93f3-81ff62b0fe25"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (138)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, {3.9472664882721004`*^9, 3.947266488328705*^9}, 
   3.947267254192007*^9, {3.9472674918473606`*^9, 3.9472674920401783`*^9}, {
   3.9472678025759907`*^9, 
   3.9472678043681984`*^9}},ExpressionUUID->"e2ef6a68-4b48-0244-8a54-\
fa236c49260a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "138", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9472675055282383`*^9, 3.947267518768564*^9}, {
  3.947267809519802*^9, 3.9472678165522823`*^9}},
 CellLabel->
  "In[161]:=",ExpressionUUID->"c4f51896-802b-b142-9475-167cb2128669"],

Cell["anti[ABCD] = dp[ABCD]  ", "Subsubsection",
 CellChangeTimes->{{3.946455475830339*^9, 3.946455478286655*^9}, 
   3.946459038326063*^9, {3.9464592755826244`*^9, 3.9464592769669704`*^9}, {
   3.9467231315639515`*^9, 
   3.946723138986958*^9}},ExpressionUUID->"7950e7de-d186-f74a-a8a5-\
fd54c8f10a81"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.94670562716325*^9, 3.946705669762529*^9}, {
  3.946705703747917*^9, 3.946705705034683*^9}, {3.946723187171833*^9, 
  3.94672321343519*^9}, {3.9472675016819763`*^9, 3.947267526383997*^9}},
 CellLabel->
  "In[162]:=",ExpressionUUID->"594386a8-7635-5547-a8e8-3f8f3ee44abb"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467057067847385`*^9, {3.946723195174942*^9, 3.946723214119566*^9}, 
   3.9472675289937096`*^9, 3.947267821385868*^9},
 CellLabel->
  "Out[162]=",ExpressionUUID->"782dae68-8def-ce40-afcd-2ade73c7e9b8"]
}, Open  ]],

Cell["anti[ABCD] = stein[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946459029088383*^9, 
  3.9464590520700207`*^9}},ExpressionUUID->"74b8beab-fccc-3847-9404-\
d273ccfe093e"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.9467062678657017`*^9, 3.946706303786476*^9}, 
   3.947267556608343*^9},
 CellLabel->
  "In[163]:=",ExpressionUUID->"13c067e6-d03a-454f-b702-64e5d6226744"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946706381229746*^9, 3.946723327056368*^9, 
  3.947267596599533*^9, 3.9472679281264324`*^9},
 CellLabel->
  "Out[163]=",ExpressionUUID->"b5e9c3d8-de6a-e242-8bc9-4edf5338e601"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (139)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, {3.9472664882721004`*^9, 3.947266488328705*^9}, 
   3.947267254192007*^9, {3.9472674918473606`*^9, 3.9472674920401783`*^9}, {
   3.9472679447754784`*^9, 
   3.947267945239359*^9}},ExpressionUUID->"ee541790-f297-3b41-befe-\
9d0e0af4fc4c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "139", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9472675055282383`*^9, 3.947267518768564*^9}, {
  3.947267952000536*^9, 3.9472679581274033`*^9}},
 CellLabel->
  "In[165]:=",ExpressionUUID->"80aa0a8e-b84a-7d42-9e5d-d22d69243ae4"],

Cell["anti[ABCD] = dp[ABCD]  ", "Subsubsection",
 CellChangeTimes->{{3.946455475830339*^9, 3.946455478286655*^9}, 
   3.946459038326063*^9, {3.9464592755826244`*^9, 3.9464592769669704`*^9}, {
   3.9467231315639515`*^9, 
   3.946723138986958*^9}},ExpressionUUID->"939977d1-5cbd-5d42-8916-\
ddcb40e47c47"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.94670562716325*^9, 3.946705669762529*^9}, {
  3.946705703747917*^9, 3.946705705034683*^9}, {3.946723187171833*^9, 
  3.94672321343519*^9}, {3.9472675016819763`*^9, 3.947267526383997*^9}},
 CellLabel->
  "In[166]:=",ExpressionUUID->"3c99965e-f594-0045-a855-db2a5a70a964"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467057067847385`*^9, {3.946723195174942*^9, 3.946723214119566*^9}, 
   3.9472675289937096`*^9, 3.9472679692902203`*^9},
 CellLabel->
  "Out[166]=",ExpressionUUID->"73a51740-534d-2942-bc8c-9cb6fd119192"]
}, Open  ]],

Cell["anti[ABCD] = stein[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946459029088383*^9, 
  3.9464590520700207`*^9}},ExpressionUUID->"e2961a94-c519-4047-9d59-\
e2044a39e1e9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.9467062678657017`*^9, 3.946706303786476*^9}, 
   3.947267556608343*^9},
 CellLabel->
  "In[167]:=",ExpressionUUID->"23808561-4edd-2e40-b114-c7d0948eb1e2"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946706381229746*^9, 3.946723327056368*^9, 
  3.947267596599533*^9, 3.947268096088833*^9},
 CellLabel->
  "Out[167]=",ExpressionUUID->"06886277-73e7-0a4b-9d2f-96bd14852f26"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (143)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, {3.9472664882721004`*^9, 3.947266488328705*^9}, 
   3.947267254192007*^9, {3.9472674918473606`*^9, 3.9472674920401783`*^9}, {
   3.9472679447754784`*^9, 3.947267945239359*^9}, {3.947268020775078*^9, 
   3.947268020975521*^9}},ExpressionUUID->"09e901c8-6c51-7448-9026-\
3aa7e530b4ae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "143", "]"}]}]], "Input",
 CellChangeTimes->{{3.9472675055282383`*^9, 3.947267518768564*^9}, {
  3.947267952000536*^9, 3.9472679581274033`*^9}, {3.947268025431593*^9, 
  3.9472680276642666`*^9}},
 CellLabel->
  "In[168]:=",ExpressionUUID->"b4e7059a-5dc1-1842-bd93-d2532403606b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
           SuperscriptBox["c", "3"]}], ")"}], "2"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "12"], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "10"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "8"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         SuperscriptBox["c", "8"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "8"], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "10"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "10"], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "8"], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "10"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
         SuperscriptBox["c", "3"]}], ")"}], "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
          SuperscriptBox["c", "3"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "8"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.9472681075364647`*^9},
 CellLabel->
  "Out[168]=",ExpressionUUID->"1844c505-cd58-934a-b285-9b545519062d"]
}, Open  ]],

Cell["anti[ABCD] = dp[ABCD]  ", "Subsubsection",
 CellChangeTimes->{{3.946455475830339*^9, 3.946455478286655*^9}, 
   3.946459038326063*^9, {3.9464592755826244`*^9, 3.9464592769669704`*^9}, {
   3.9467231315639515`*^9, 
   3.946723138986958*^9}},ExpressionUUID->"ed052706-41a9-4d4a-8a4e-\
68afd4db9247"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.94670562716325*^9, 3.946705669762529*^9}, {
  3.946705703747917*^9, 3.946705705034683*^9}, {3.946723187171833*^9, 
  3.94672321343519*^9}, {3.9472675016819763`*^9, 3.947267526383997*^9}},
 CellLabel->
  "In[169]:=",ExpressionUUID->"14f3fc78-f22b-274e-bb57-23f2ee51eef4"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467057067847385`*^9, {3.946723195174942*^9, 3.946723214119566*^9}, 
   3.9472675289937096`*^9, 3.9472679692902203`*^9, 3.9472681104257507`*^9},
 CellLabel->
  "Out[169]=",ExpressionUUID->"9d81bb58-a068-a748-b5fe-2b0f1565054e"]
}, Open  ]],

Cell["anti[ABCD] = stein[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946459029088383*^9, 
  3.9464590520700207`*^9}},ExpressionUUID->"6b3589d0-7eb7-514a-b7ce-\
a798d85a97d5"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.9467062678657017`*^9, 3.946706303786476*^9}, 
   3.947267556608343*^9},
 CellLabel->
  "In[170]:=",ExpressionUUID->"7ae3f305-503a-3e4a-b179-c46706f9ec88"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946706381229746*^9, 3.946723327056368*^9, 
  3.947267596599533*^9, 3.947268114000675*^9},
 CellLabel->
  "Out[170]=",ExpressionUUID->"10f08a43-2814-7b4d-afc9-5eb03e3d4c53"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (182)", "Subsection",
 CellChangeTimes->{{3.9467054206935368`*^9, 3.94670542945281*^9}, 
   3.947268169839588*^9},ExpressionUUID->"3bec1bea-cbef-a441-a045-\
8a88b7252d46"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "182", "]"}]}]], "Input",
 CellChangeTimes->{3.947268187808386*^9},
 CellLabel->
  "In[171]:=",ExpressionUUID->"88806f8d-5537-8942-89a5-211422431bf7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
           SuperscriptBox["c", "3"]}], ")"}], "2"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "12"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "6"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "10"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
          SuperscriptBox["c", "3"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"20", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "8"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "-", 
         RowBox[{"15", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"9", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "6"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "3"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "10"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "8"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "12"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "10"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
         SuperscriptBox["c", "3"]}], ")"}], "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"20", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "-", 
         RowBox[{"15", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "4"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
           SuperscriptBox["c", "3"]}], ")"}], "2"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "8"]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "3"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "6"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "6"], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      SuperscriptBox["c", "6"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947268188624832*^9},
 CellLabel->
  "Out[171]=",ExpressionUUID->"c542d6be-bf29-e540-a596-e43c57c149f2"],

Cell["m[ABCD] = dp[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946707388707804*^9, 
  3.94670739104048*^9}},ExpressionUUID->"039fe4b5-d318-574b-8b31-\
a774254f4caa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.946707477040592*^9, 3.9467074902729607`*^9}, {
  3.9472681853540783`*^9, 3.9472681925274296`*^9}},
 CellLabel->
  "In[172]:=",ExpressionUUID->"91c9b5ce-1eee-b349-a7d8-40020d69029d"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946707493016908*^9, 3.947268193996113*^9},
 CellLabel->
  "Out[172]=",ExpressionUUID->"f784ab0a-0c29-b14b-bf44-db1d5e4a1dff"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (186)", "Subsection",
 CellChangeTimes->{{3.94670543078184*^9, 3.94670543980492*^9}, {
   3.946708032583349*^9, 3.946708046582894*^9}, {3.946708083815878*^9, 
   3.946708103127428*^9}, {3.946708143887995*^9, 3.946708211823763*^9}, {
   3.9467234524268036`*^9, 3.946723458026209*^9}, 
   3.947268276335312*^9},ExpressionUUID->"f5186099-17e1-0849-a468-\
bcce71b17fc4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "186", "]"}]}]], "Input",
 CellChangeTimes->{3.947268291224102*^9},
 CellLabel->
  "In[175]:=",ExpressionUUID->"b0798158-bf6c-a544-b905-f4c823f51ef3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
            SuperscriptBox["c", "3"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "-", 
        RowBox[{"b", " ", "c", " ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], "]"}], " ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           SuperscriptBox["a", "4"], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"]}]}], ")"}]}]}], "]"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
            SuperscriptBox["c", "3"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
        RowBox[{"b", " ", "c", " ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], "]"}], " ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           SuperscriptBox["a", "4"], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"]}]}], ")"}]}]}], "]"}]}]}], ")"}]}], 
     ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "2"], "+", 
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "4"], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], "2"]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "-", "c"}], ")"}], " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "2"], "+", 
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "4"], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], "2"]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "4"], "-", 
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{"a", " ", "c", " ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           SuperscriptBox["a", "4"], "-", 
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], "]"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"a", " ", "c", " ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           SuperscriptBox["a", "4"], "-", 
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "4"], "-", 
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"a", " ", "b"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"a", " ", "b"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], "+", 
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "4"], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], "2"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], "+", 
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "4"], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], "2"]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
            SuperscriptBox["c", "3"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "-", 
        RowBox[{"a", " ", "b", " ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], "+", 
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], "]"}], " ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           SuperscriptBox["a", "4"], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"]}]}], ")"}]}]}], "]"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
            SuperscriptBox["c", "3"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
        RowBox[{"a", " ", "b", " ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], "+", 
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], "]"}], " ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           SuperscriptBox["a", "4"], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"]}]}], ")"}]}]}], "]"}]}]}], ")"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"b", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"a", " ", "b"}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{"a", " ", "b"}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9472682933525314`*^9, 3.9472683634525833`*^9},
 CellLabel->
  "Out[175]=",ExpressionUUID->"28aa2426-a34b-b14e-b39f-2f80da84268d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["anti[ABCD] = dp (ABCD) ", "Subsubsection",
 CellChangeTimes->{{3.946706976860153*^9, 
  3.946706992833111*^9}},ExpressionUUID->"2e23cce6-d1dd-b446-a615-\
419e8b6d7cd9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.946707021017731*^9, 3.946707056313673*^9}, 
   3.9472668158490314`*^9},
 CellLabel->
  "In[176]:=",ExpressionUUID->"ddfb16ae-a679-3342-bc6c-48b5a05f3229"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9467070576887913`*^9, 3.94726682222633*^9, 
  3.9472683648664227`*^9},
 CellLabel->
  "Out[176]=",ExpressionUUID->"d146f53f-7308-624d-bb6b-fbf4ac01421e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["dp (ABCD) = dp (EFGH)", "Subsubsection",
 CellChangeTimes->{{3.946706980171034*^9, 3.94670699700077*^9}, {
  3.946707201032797*^9, 3.946707202193568*^9}, {3.946707270648503*^9, 
  3.946707271568043*^9}},ExpressionUUID->"9202140e-c1f6-0146-af41-\
660a56d80a88"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.946707144481069*^9, 3.9467071762171497`*^9}, {
   3.946707208105603*^9, 3.946707218025624*^9}, 3.947266847280876*^9},
 CellLabel->
  "In[177]:=",ExpressionUUID->"d5746fb7-284c-794f-83e6-0b975c1c4a58"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9467072098595047`*^9, 3.947266848635239*^9, 
  3.9472683676420174`*^9},
 CellLabel->
  "Out[177]=",ExpressionUUID->"618afac4-6149-e947-9166-f213db43ee54"]
}, Open  ]]
}, Open  ]],

Cell["persp[ABCD, GHEF]", "Subsubsection",
 CellChangeTimes->{{3.9467075353152523`*^9, 3.946707536281472*^9}, {
  3.9467075930568504`*^9, 
  3.946707593112597*^9}},ExpressionUUID->"a74c0314-453e-174a-b275-\
e2dbd6475261"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"PerspectiveQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptG", ",", "ptH", ",", "ptE", ",", "ptF"}], "}"}]}], "]"}], 
   ",", "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.9467054493653984`*^9, 3.946705454065166*^9}, {
  3.946707647783938*^9, 3.946707654960737*^9}, {3.946723526946409*^9, 
  3.9467235286585865`*^9}, {3.9472682890654182`*^9, 3.9472682967754936`*^9}},
 CellLabel->
  "In[174]:=",ExpressionUUID->"03a76afb-52ed-c640-9862-18d664851e52"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946707658772414*^9, 3.9467077793567142`*^9, 
  3.946789296884497*^9, 3.947268298166445*^9},
 CellLabel->
  "Out[174]=",ExpressionUUID->"7a6e033d-eee6-9c44-afea-569ead810413"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (216)", "Subsection",
 CellChangeTimes->{{3.9467054206935368`*^9, 3.94670542945281*^9}, {
  3.947268471527626*^9, 
  3.947268473663458*^9}},ExpressionUUID->"425a58b3-97d8-ce41-9e86-\
d9eab15ec7e1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "216", "]"}]}]], "Input",
 CellChangeTimes->{{3.9472684861437645`*^9, 3.9472684891601143`*^9}},
 CellLabel->
  "In[178]:=",ExpressionUUID->"2b57a823-2f53-0f46-8ed3-84c4f0bd9ef9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
           SuperscriptBox["c", "3"]}], ")"}], "2"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "10"], "-", 
        RowBox[{
         SuperscriptBox["c", "6"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "8"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "12"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "3"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "10"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"19", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "8"], "+", 
           RowBox[{
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           SuperscriptBox["c", "8"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "8"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"13", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "8"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "10"], "+", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "4"]}], "-", 
          RowBox[{
           SuperscriptBox["a", "8"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              SuperscriptBox["b", "4"]}], "+", 
             RowBox[{"6", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{"5", " ", 
              SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "6"], "-", 
             RowBox[{
              SuperscriptBox["b", "4"], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "4"]}], "+", 
             SuperscriptBox["c", "6"]}], ")"}]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "6"], " ", 
              SuperscriptBox["c", "2"]}], "-", 
             RowBox[{
              SuperscriptBox["b", "4"], " ", 
              SuperscriptBox["c", "4"]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "6"]}], "+", 
             SuperscriptBox["c", "8"]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "10"], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], "+", 
            SuperscriptBox["c", "2"]}], ")"}], "3"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           SuperscriptBox["c", "4"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "10"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
           SuperscriptBox["c", "3"]}], ")"}], "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"13", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"10", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "8"], "+", 
           RowBox[{
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"19", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "-", 
           RowBox[{"10", " ", 
            SuperscriptBox["c", "8"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "8"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"14", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "8"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "10"]}], "+", 
        RowBox[{
         SuperscriptBox["c", "6"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "8"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.9472684899379005`*^9},
 CellLabel->
  "Out[178]=",ExpressionUUID->"481d32e9-77fb-734b-a07f-ab43b901a956"]
}, Open  ]],

Cell["m[ABCD] = dp[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946707388707804*^9, 
  3.94670739104048*^9}},ExpressionUUID->"f769db25-cf4b-fe48-97c5-\
699816fa858c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.946707477040592*^9, 3.9467074902729607`*^9}, {
  3.947268482202196*^9, 3.9472684941921177`*^9}},
 CellLabel->
  "In[179]:=",ExpressionUUID->"65aec95c-6057-fe43-98eb-e4729d3038f9"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946707493016908*^9, 3.9472684951511345`*^9},
 CellLabel->
  "Out[179]=",ExpressionUUID->"f376dbfe-247c-d54e-9c90-5d1174d8b9e9"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (343)", "Subsection",
 CellChangeTimes->{{3.9467054206935368`*^9, 3.94670542945281*^9}, {
  3.947268471527626*^9, 3.947268473663458*^9}, {3.947268569663685*^9, 
  3.9472685701278973`*^9}},ExpressionUUID->"3d09b413-0fda-f345-bf9a-\
07874290d5f6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "343", "]"}]}]], "Input",
 CellChangeTimes->{{3.9472684861437645`*^9, 3.9472684891601143`*^9}, {
  3.9472685800321255`*^9, 3.9472685805356483`*^9}},
 CellLabel->
  "In[180]:=",ExpressionUUID->"06ca99e4-9b0b-a441-b634-ace33659d420"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "6"], "-", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
             SuperscriptBox["c", "3"]}], ")"}], "2"], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["b", "2"]}], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "8"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"7", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
            SuperscriptBox["c", "3"]}], ")"}], "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"18", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "14"], "-", 
      RowBox[{
       SuperscriptBox["a", "12"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "10"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"19", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"21", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], "+", 
          SuperscriptBox["c", "2"]}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         SuperscriptBox["c", "6"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"21", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"35", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"35", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "8"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"20", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"30", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"35", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "10"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "8"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "8"]}], "+", 
         RowBox[{"21", " ", 
          SuperscriptBox["c", "10"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "12"], "+", 
         RowBox[{
          SuperscriptBox["b", "10"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "8"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "6"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "8"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "10"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["c", "12"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "12"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "10"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         SuperscriptBox["c", "4"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         SuperscriptBox["c", "4"]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "6"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"11", " ", 
          SuperscriptBox["b", "8"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "12"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "10"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         SuperscriptBox["c", "6"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "8"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "10"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "8"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "6"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "10"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "14"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "12"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "10"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"21", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         SuperscriptBox["c", "4"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "6"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"35", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "8"], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "8"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"30", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"35", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "10"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "8"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"20", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "6"]}], "-", 
         RowBox[{"35", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "8"]}], "+", 
         RowBox[{"21", " ", 
          SuperscriptBox["c", "10"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "4"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "8"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
            SuperscriptBox["c", "3"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"18", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"12", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.9472684899379005`*^9, 3.9472685812414894`*^9},
 CellLabel->
  "Out[180]=",ExpressionUUID->"c3e8c0ee-6253-ec47-b7fc-ebb2b4388829"]
}, Open  ]],

Cell["m[ABCD] = dp[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946707388707804*^9, 
  3.94670739104048*^9}},ExpressionUUID->"e5ff7923-dcaa-ca43-8b80-\
d08aaecc4310"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.946707477040592*^9, 3.9467074902729607`*^9}, {
  3.947268482202196*^9, 3.9472684941921177`*^9}},
 CellLabel->
  "In[181]:=",ExpressionUUID->"1d0f8264-b184-694d-a405-ebda81d52dd4"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946707493016908*^9, 3.9472684951511345`*^9, 
  3.9472685916835804`*^9},
 CellLabel->
  "Out[181]=",ExpressionUUID->"4b3810b5-ee5e-b844-ab08-7db05174ba50"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (378)", "Subsection",
 CellChangeTimes->{{3.946705381516901*^9, 3.946705401725176*^9}, {
  3.947268638527561*^9, 
  3.9472686411110134`*^9}},ExpressionUUID->"d7647f9c-3ed9-3d4f-a08e-\
785a6587d6cb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "378", "]"}]}]], "Input",
 CellChangeTimes->{{3.947268649847784*^9, 3.947268652630993*^9}},
 CellLabel->
  "In[185]:=",ExpressionUUID->"2dbbe913-b9aa-f34a-b379-44e430f8df15"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.947268653399544*^9, 3.947268763924715*^9},
 CellLabel->
  "Out[185]=",ExpressionUUID->"d89288dd-f69b-e24e-8a49-a5f5ab4480bb"]
}, Open  ]],

Cell["anti[ABCD] = dp (ABCD) ", "Subsubsection",
 CellChangeTimes->{{3.946706976860153*^9, 
  3.946706992833111*^9}},ExpressionUUID->"35e64947-99f7-1045-b169-\
ef2f3352bf14"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.946707021017731*^9, 3.946707056313673*^9}, {
  3.9472686469624634`*^9, 3.947268657808174*^9}},
 CellLabel->
  "In[183]:=",ExpressionUUID->"6c80ac55-4516-f544-ab0b-3eb42efa6275"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9467070576887913`*^9, 3.9472686586831646`*^9},
 CellLabel->
  "Out[183]=",ExpressionUUID->"4d2037c2-9901-3949-9446-ebe5849da358"]
}, Open  ]],

Cell[CellGroupData[{

Cell["dp (ABCD) = dp (EFGH)", "Subsubsection",
 CellChangeTimes->{{3.946706980171034*^9, 3.94670699700077*^9}, {
  3.946707201032797*^9, 3.9467072021935678`*^9}, {3.946707270648503*^9, 
  3.946707271568043*^9}},ExpressionUUID->"936f7470-59e5-1e4c-96e4-\
6c6aab2e84dc"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.946707144481069*^9, 3.9467071762171497`*^9}, {
   3.9467072081056027`*^9, 3.946707218025624*^9}, 3.9472686693034286`*^9},
 CellLabel->
  "In[184]:=",ExpressionUUID->"49a99af6-52e1-8b4a-9053-29ab8f037d0b"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9467072098595047`*^9, 3.9472686836303253`*^9},
 CellLabel->
  "Out[184]=",ExpressionUUID->"57d2b035-6553-8741-bba4-54602358025a"],

Cell[CellGroupData[{

Cell["persp[ABCD, GHEF]", "Subsubsection",
 CellChangeTimes->{{3.9467075353152523`*^9, 3.946707536281472*^9}, {
  3.9467075930568504`*^9, 
  3.946707593112597*^9}},ExpressionUUID->"2c996baf-d537-6745-8a37-\
8ee8cb9bc5bc"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"PerspectiveQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptG", ",", "ptH", ",", "ptE", ",", "ptF"}], "}"}]}], "]"}], 
   ",", "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.9467054493653984`*^9, 3.946705454065166*^9}, {
   3.946707647783938*^9, 3.946707654960737*^9}, {3.946723526946409*^9, 
   3.9467235286585865`*^9}, 3.9472687598401394`*^9},
 CellLabel->
  "In[186]:=",ExpressionUUID->"b1c87d5b-6413-3044-bb75-786c65fc19e8"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946707658772414*^9, 3.9467077793567142`*^9, 
  3.946789296884497*^9, 3.9472687669303703`*^9},
 CellLabel->
  "Out[186]=",ExpressionUUID->"c066f762-461d-2f4a-a699-741b3a980332"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (389)", "Subsection",
 CellChangeTimes->{{3.9467054100776978`*^9, 
  3.946705413275881*^9}},ExpressionUUID->"4a04183d-08f6-2248-8220-\
e95bcb7af714"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "389", "]"}]}]], "Input",
 CellChangeTimes->{3.947269338999361*^9},
 CellLabel->
  "In[201]:=",ExpressionUUID->"91b88562-5313-9543-aff7-3306fad03c4c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         SuperscriptBox["c", "4"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "8"], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         SuperscriptBox["c", "4"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "6"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
         SuperscriptBox["c", "3"]}], ")"}], "2"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "6"], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         SuperscriptBox["c", "4"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         SuperscriptBox["c", "4"]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "8"]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "3"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "8"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "3"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.9472693398679543`*^9},
 CellLabel->
  "Out[201]=",ExpressionUUID->"e8adaab0-bee4-9742-83cd-e5993630796d"],

Cell["m[ABCD] = stein[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.94670729694767*^9, 
  3.946707299905752*^9}},ExpressionUUID->"a1bb827c-282c-8d40-8928-\
945900c69a17"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.9467073238810043`*^9, 3.946707368594757*^9}, {
  3.9472693362017097`*^9, 3.9472693366879196`*^9}},
 CellLabel->
  "In[202]:=",ExpressionUUID->"5cad5e9f-fdf1-0747-bdf7-8e4aed69e08e"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9467073534495106`*^9, 3.946707370477238*^9}, 
   3.9472693429303207`*^9},
 CellLabel->
  "Out[202]=",ExpressionUUID->"0fabdffa-0225-a84d-8518-7b992527555b"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (568)", "Subsection",
 CellChangeTimes->{{3.946455610253751*^9, 
  3.9464556189469223`*^9}},ExpressionUUID->"2dc3a68f-0f11-6847-8034-\
486d02ef6993"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "568", "]"}]}]], "Input",
 CellChangeTimes->{3.9472688270790024`*^9},
 CellLabel->
  "In[187]:=",ExpressionUUID->"77abef86-b745-ac43-b4d5-1af60d791f99"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "12"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "10"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
          SuperscriptBox["c", "3"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         SuperscriptBox["c", "4"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "12"], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "10"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "8"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "-", 
         SuperscriptBox["c", "8"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "8"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "10"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "8"]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "3"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "10"], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "8"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "10"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
         SuperscriptBox["c", "3"]}], ")"}], "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "8"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "10"], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "3"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "8"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"7", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "8"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         SuperscriptBox["c", "4"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "6"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "8"]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "3"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "8"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "3"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.947268828068201*^9},
 CellLabel->
  "Out[187]=",ExpressionUUID->"0b5481b7-ec9d-ff43-a757-60c7a478269b"],

Cell["centro[ABCD] = stein[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946455506638082*^9, 
  3.946455509595903*^9}},ExpressionUUID->"adeb5a20-cdf1-2649-8006-\
b06c55e0b43d"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CentrocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.946006645207369*^9, 3.946006646278789*^9}, 
   3.94600677265432*^9, {3.946006994439163*^9, 3.946007052263378*^9}, {
   3.946007169215803*^9, 3.946007171351696*^9}, {3.946007757991848*^9, 
   3.946007758895792*^9}, {3.946706920481632*^9, 3.9467069444498997`*^9}, {
   3.9472688251213856`*^9, 3.9472688328558693`*^9}},
 CellLabel->
  "In[188]:=",ExpressionUUID->"697ea50b-fdac-e441-aad2-4f7019693805"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.946006646408167*^9, 3.946006774573641*^9, 3.946006961916352*^9, {
   3.94600699511776*^9, 3.9460070596053314`*^9}, 3.946007174912885*^9, 
   3.946007760232868*^9, 3.946008334059845*^9, 3.946021099508396*^9, 
   3.946021162089815*^9, 3.946023856544445*^9, 3.94645603623106*^9, 
   3.946706902821503*^9, 3.9467069468733654`*^9, 3.947268834364641*^9},
 CellLabel->
  "Out[188]=",ExpressionUUID->"007bc9fb-5bbf-834e-bf60-de37b501d1fa"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (571)", "Subsection",
 CellChangeTimes->{{3.94670543078184*^9, 3.94670543980492*^9}, {
   3.946708032583349*^9, 3.946708046582894*^9}, {3.946708083815878*^9, 
   3.946708103127428*^9}, {3.946708143887995*^9, 3.946708211823763*^9}, {
   3.9467234524268036`*^9, 3.946723458026209*^9}, 
   3.947268889048147*^9},ExpressionUUID->"cdf17696-4d13-864f-8ca7-\
1240d484e052"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "571", "]"}]}]], "Input",
 CellChangeTimes->{3.9472688988157406`*^9},
 CellLabel->
  "In[189]:=",ExpressionUUID->"ffe858f3-e1b1-5e4b-8f75-484722bca4ed"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], " ", 
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "12"], "+", 
        RowBox[{
         SuperscriptBox["c", "6"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], "+", 
            SuperscriptBox["c", "2"]}], ")"}], "3"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "10"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"9", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"20", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "8"], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"15", " ", 
            SuperscriptBox["c", "8"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "4"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "10"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "3"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           SuperscriptBox["c", "6"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "8"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "12"], "-", 
        RowBox[{"6", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "6"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "10"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
           SuperscriptBox["c", "3"]}], ")"}], "4"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"15", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"20", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      SuperscriptBox["c", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.947268899588728*^9},
 CellLabel->
  "Out[189]=",ExpressionUUID->"2558e743-1feb-334f-bde3-8ff73b386d30"]
}, Open  ]],

Cell["persp[ABCD, GHEF]", "Subsubsection",
 CellChangeTimes->{{3.9467075353152523`*^9, 3.946707536281472*^9}, {
  3.9467075930568504`*^9, 
  3.946707593112597*^9}},ExpressionUUID->"2bbd9b20-0b93-0f4d-a010-\
11140b606f1b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"PerspectiveQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptG", ",", "ptH", ",", "ptE", ",", "ptF"}], "}"}]}], "]"}], 
   ",", "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.9467054493653984`*^9, 3.946705454065166*^9}, {
   3.946707647783938*^9, 3.946707654960737*^9}, {3.946723526946409*^9, 
   3.9467235286585865`*^9}, 3.94726890324041*^9},
 CellLabel->
  "In[190]:=",ExpressionUUID->"6c44a4c6-55d6-3c4f-9b0b-b9a70130e564"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946707658772414*^9, 3.9467077793567142`*^9, 
  3.946789296884497*^9, 3.94726890443664*^9},
 CellLabel->
  "Out[190]=",ExpressionUUID->"45aeebae-39ac-9947-b0a8-3f057aebb42f"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (847)", "Subsection",
 CellChangeTimes->{{3.946705381516901*^9, 3.946705401725176*^9}, {
  3.9472689775437355`*^9, 
  3.9472689796877384`*^9}},ExpressionUUID->"7b5d1626-2fe7-3c41-bc9f-\
ad82ee7fb000"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "847", "]"}]}]], "Input",
 CellChangeTimes->{
  3.9472689874001446`*^9, {3.9472690497436314`*^9, 3.9472690512155952`*^9}},
 CellLabel->
  "In[193]:=",ExpressionUUID->"f3b18168-3d73-a64a-b3ab-5cb6d78ffd51"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "c"}], ")"}], " ", 
        SuperscriptBox["c", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "8"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["c", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["c", "4"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "4"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{"6", " ", 
              SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "6"]}], "+", 
        SuperscriptBox["c", "8"], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "-", "c"}], ")"}], " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], "+", 
            SuperscriptBox["c", "2"]}], ")"}], "3"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.94726898822423*^9, 3.94726905202903*^9},
 CellLabel->
  "Out[193]=",ExpressionUUID->"5649be37-9d35-8a4b-bdfb-d6e51c11b781"],

Cell["anti[ABCD] = dp (ABCD) ", "Subsubsection",
 CellChangeTimes->{{3.946706976860153*^9, 
  3.946706992833111*^9}},ExpressionUUID->"b06ed08f-0fc2-f04a-8a2a-\
b9eec0d53560"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.946707021017731*^9, 3.946707056313673*^9}, {
  3.9472689841695347`*^9, 3.947268997167982*^9}},
 CellLabel->
  "In[194]:=",ExpressionUUID->"8e7ef6f9-6c78-2c46-9612-2e55f92788c3"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9467070576887913`*^9, 3.9472689978834534`*^9, 
  3.94726905738632*^9},
 CellLabel->
  "Out[194]=",ExpressionUUID->"0b0d65a0-1c78-ff48-85f9-59f8b300d1e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["dp (ABCD) = dp (EFGH)", "Subsubsection",
 CellChangeTimes->{{3.946706980171034*^9, 3.94670699700077*^9}, {
  3.946707201032797*^9, 3.9467072021935678`*^9}, {3.946707270648503*^9, 
  3.946707271568043*^9}},ExpressionUUID->"0a1b2a12-5208-8348-8e41-\
aa6cb5cf2bbf"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.946707144481069*^9, 3.9467071762171497`*^9}, {
   3.9467072081056027`*^9, 3.946707218025624*^9}, 3.9472690345351295`*^9},
 CellLabel->
  "In[195]:=",ExpressionUUID->"95ea092a-84b0-084d-82f2-8531b1789692"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9467072098595047`*^9, 3.947269062474859*^9},
 CellLabel->
  "Out[195]=",ExpressionUUID->"0e552380-3dbe-684e-85af-7e63501a7fb5"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (933)", "Subsection",
 CellChangeTimes->{{3.946705381516901*^9, 3.946705401725176*^9}, {
  3.9472689775437355`*^9, 3.9472689796877384`*^9}, {3.9472691032074184`*^9, 
  3.947269103862814*^9}},ExpressionUUID->"09da417d-05bc-9540-b1b1-\
685207bad5e6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "933", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.9472689874001446`*^9, {3.9472690497436314`*^9, 3.9472690512155952`*^9}, {
   3.9472691091520348`*^9, 3.9472691515039444`*^9}, {3.94726920429541*^9, 
   3.947269208343113*^9}},
 CellLabel->
  "In[198]:=",ExpressionUUID->"b36306ba-bfdf-8a42-8f81-0375abc513d7"],

Cell["anti[ABCD] = dp (ABCD) ", "Subsubsection",
 CellChangeTimes->{{3.946706976860153*^9, 
  3.946706992833111*^9}},ExpressionUUID->"923bc323-e6f1-804c-8236-\
8d189f0d241d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.946707021017731*^9, 3.946707056313673*^9}, {
  3.9472689841695347`*^9, 3.947268997167982*^9}},
 CellLabel->
  "In[199]:=",ExpressionUUID->"e310df99-7ba8-bb4c-9b13-35ed3afeafa8"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9467070576887913`*^9, 3.9472689978834534`*^9, 
  3.94726905738632*^9, 3.947269218018284*^9},
 CellLabel->
  "Out[199]=",ExpressionUUID->"33558438-430d-9f4e-9d43-c9ec95c3bdd9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["dp (ABCD) = dp (EFGH)", "Subsubsection",
 CellChangeTimes->{{3.946706980171034*^9, 3.94670699700077*^9}, {
  3.946707201032797*^9, 3.9467072021935678`*^9}, {3.946707270648503*^9, 
  3.946707271568043*^9}},ExpressionUUID->"5aa955bd-2220-c744-b448-\
725d7d439eb1"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cortho"}], "]"}]], "Input",
 CellChangeTimes->{{3.946707144481069*^9, 3.9467071762171497`*^9}, {
   3.9467072081056027`*^9, 3.946707218025624*^9}, 3.9472690345351295`*^9},
 CellLabel->
  "In[200]:=",ExpressionUUID->"2789c842-e60f-5d40-b448-a28fabca5c0a"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9467072098595047`*^9, 3.947269062474859*^9, 
  3.947269262305252*^9},
 CellLabel->
  "Out[200]=",ExpressionUUID->"0f2a48cf-e4dc-7a4b-b624-431e955ae188"]
}, Closed]]
},
CellGrouping->Manual,
WindowSize->{1293.2830188679245`, 654.7924528301886},
WindowMargins->{{0, Automatic}, {Automatic, -0.6792452830188679}},
FrontEndVersion->"14.0 for Microsoft Windows (64-bit) (December 12, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"f520fea5-cffb-e244-93fc-e6a1bbcd0e75"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 307, 5, 98, "Title",ExpressionUUID->"29001ab6-6556-7b4b-a45f-7ca429ca0ceb"],
Cell[868, 27, 1424, 24, 173, "Text",ExpressionUUID->"08758b0a-705f-b842-b1d6-6a28a79b6218"],
Cell[CellGroupData[{
Cell[2317, 55, 200, 4, 67, "Section",ExpressionUUID->"5e4c6aa2-710c-4599-941e-5f13e499af78"],
Cell[CellGroupData[{
Cell[2542, 63, 1660, 38, 105, "Input",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"],
Cell[4205, 103, 533, 13, 32, "Output",ExpressionUUID->"44a1e5e3-d71e-2a42-b8c2-4a18f4dc475e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4775, 121, 662, 15, 28, "Input",ExpressionUUID->"0fa13524-efd5-b142-bee7-4031f8b5afde"],
Cell[5440, 138, 849, 22, 32, "Output",ExpressionUUID->"229534fb-6fc5-924e-9984-0e51a2819b41"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6326, 165, 562, 12, 28, "Input",ExpressionUUID->"87df9985-2672-474d-a525-2ead7c5a73f6"],
Cell[6891, 179, 1841, 52, 51, "Output",ExpressionUUID->"c921d4d4-440a-1544-9eb5-8b2c5114dbfb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8769, 236, 476, 11, 28, "Input",ExpressionUUID->"b1253ee8-a010-d14b-9c7e-3b5e0e72737d"],
Cell[9248, 249, 2099, 64, 35, "Output",ExpressionUUID->"989c4f15-b8e9-0e4d-87c8-d821ff46140c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11384, 318, 340, 6, 28, "Input",ExpressionUUID->"893fef3b-ebfc-114c-858b-2d8fe70902bb"],
Cell[11727, 326, 1013, 29, 32, "Output",ExpressionUUID->"c6e87078-e858-4b47-817d-b45b9b85196e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12789, 361, 255, 4, 67, "Section",ExpressionUUID->"cf60f297-bbcd-8748-b453-e7118b4e0a98"],
Cell[CellGroupData[{
Cell[13069, 369, 212, 4, 54, "Subsection",ExpressionUUID->"c8cca55e-04f1-8f4a-b670-3c3179eed91e"],
Cell[13284, 375, 271223, 7062, 3643, "Input",ExpressionUUID->"90297db1-2eea-6346-9338-a3e8dcfe0024"]
}, Closed]],
Cell[CellGroupData[{
Cell[284544, 7442, 215, 4, 38, "Subsection",ExpressionUUID->"79ef6085-3de7-3c49-8561-f943fbd2d431"],
Cell[284762, 7448, 434, 11, 28, "Input",ExpressionUUID->"e725b315-4161-274c-8798-a4e0c807d6a8"],
Cell[285199, 7461, 435, 11, 28, "Input",ExpressionUUID->"60fea3de-a36e-734d-b67f-75eab8f36838"],
Cell[285637, 7474, 434, 11, 28, "Input",ExpressionUUID->"422bd8e2-a85e-d748-b542-6c9b62c11efd"],
Cell[286074, 7487, 1078, 29, 28, "Input",ExpressionUUID->"d021f1ab-c58d-b74b-8aa5-a62365464cc5"],
Cell[287155, 7518, 816, 23, 28, "Input",ExpressionUUID->"023d4850-e194-b941-a762-4c9a532e11d1"],
Cell[287974, 7543, 599, 16, 28, "Input",ExpressionUUID->"62ef2468-c328-714d-8bf7-299b142a086d"],
Cell[288576, 7561, 2069, 53, 181, "Input",ExpressionUUID->"d734f707-6812-364b-b359-ac3a6bb66e72"],
Cell[290648, 7616, 1710, 46, 143, "Input",ExpressionUUID->"34f7e383-98aa-bc47-9867-166186424dd4"],
Cell[292361, 7664, 1910, 50, 162, "Input",ExpressionUUID->"4370c731-693f-a941-82c8-1f6a14f724b2"],
Cell[294274, 7716, 609, 16, 28, "Input",ExpressionUUID->"6e2024d9-4541-ea4e-a308-49a8bb9b87a5"],
Cell[294886, 7734, 1127, 29, 124, "Input",ExpressionUUID->"384fc915-4ebd-5342-9174-a166a5e7f52d"],
Cell[296016, 7765, 1391, 39, 124, "Input",ExpressionUUID->"e878baba-ea71-dd4f-b972-2e4c3753c774"],
Cell[297410, 7806, 1394, 39, 124, "Input",ExpressionUUID->"4200ee2b-abeb-b246-85fa-68f1ce5d836b"],
Cell[298807, 7847, 1326, 38, 124, "Input",ExpressionUUID->"8131db8a-5012-e741-93f3-ec6da52923f1"],
Cell[300136, 7887, 1364, 37, 143, "Input",ExpressionUUID->"3e5eb206-464c-7e4f-b628-98c50c5a4629"]
}, Closed]],
Cell[CellGroupData[{
Cell[301537, 7929, 291, 5, 38, "Subsection",ExpressionUUID->"d004e03f-8f12-9a43-865f-339812029417"],
Cell[301831, 7936, 3314, 100, 130, "Input",ExpressionUUID->"059a14ad-548f-1d43-b181-7239fd1e5301"]
}, Closed]],
Cell[CellGroupData[{
Cell[305182, 8041, 170, 3, 38, "Subsection",ExpressionUUID->"2a49be25-3c4e-430e-86c6-869880736f30"],
Cell[CellGroupData[{
Cell[305377, 8048, 217, 4, 45, "Subsubsection",ExpressionUUID->"a576f9af-1f5b-4213-b4d3-e7b66981337e"],
Cell[305597, 8054, 53880, 889, 404, "Text",ExpressionUUID->"f7950398-57cb-4ee6-bf14-597b39eb91df"],
Cell[359480, 8945, 995, 24, 86, "Input",ExpressionUUID->"cf738f77-0d96-4e62-81a0-f2a504594dc8"]
}, Closed]],
Cell[CellGroupData[{
Cell[360512, 8974, 238, 4, 37, "Subsubsection",ExpressionUUID->"f7957972-a4e9-446f-bafd-6774f0dd3699"],
Cell[360753, 8980, 813, 18, 48, "Input",ExpressionUUID->"44de57fd-6e7d-4d98-94a0-c7b93947eadd"]
}, Closed]],
Cell[CellGroupData[{
Cell[361603, 9003, 215, 4, 37, "Subsubsection",ExpressionUUID->"ae32c2db-9871-344f-aabd-a2543db56100"],
Cell[361821, 9009, 2072, 56, 101, "Input",ExpressionUUID->"db0fcba9-9144-4df7-981b-db22bb466a6e"]
}, Closed]],
Cell[CellGroupData[{
Cell[363930, 9070, 242, 4, 37, "Subsubsection",ExpressionUUID->"29f12ada-9fd0-4747-b323-2cf96d6fb52e"],
Cell[364175, 9076, 660, 15, 28, "Input",ExpressionUUID->"158fb412-c771-43ab-b43b-a357380f4a11"]
}, Closed]],
Cell[CellGroupData[{
Cell[364872, 9096, 197, 3, 37, "Subsubsection",ExpressionUUID->"5a543829-5641-9144-8dd0-57eb7cf1938d"],
Cell[365072, 9101, 1563, 42, 124, "Input",ExpressionUUID->"35cb8ff3-829e-654a-a95d-e2c972de6be9"]
}, Closed]],
Cell[CellGroupData[{
Cell[366672, 9148, 174, 3, 37, "Subsubsection",ExpressionUUID->"e039afe9-d89d-4ec4-94b9-ddb3f9f259e0"],
Cell[366849, 9153, 558, 14, 28, "Input",ExpressionUUID->"2db3c5dc-e4da-4371-937a-22cb108c81e1"]
}, Closed]],
Cell[CellGroupData[{
Cell[367444, 9172, 372, 6, 37, "Subsubsection",ExpressionUUID->"bd16b166-d506-5544-b5d0-7aa6edfca35b"],
Cell[367819, 9180, 1243, 33, 52, "Input",ExpressionUUID->"6cd12b17-ccf6-1f40-8216-e746f72a898c"]
}, Closed]],
Cell[CellGroupData[{
Cell[369099, 9218, 384, 6, 37, "Subsubsection",ExpressionUUID->"d546f79d-5ed9-4f99-846e-3ac1a3756b86"],
Cell[369486, 9226, 968, 26, 28, "Input",ExpressionUUID->"5668c7c2-b2f3-48b4-bb4e-3f493e46ab9c"],
Cell[370457, 9254, 879, 24, 28, "Input",ExpressionUUID->"d07dfa48-d9b6-433c-9d4d-8f2532f1bec3"]
}, Closed]],
Cell[CellGroupData[{
Cell[371373, 9283, 323, 5, 37, "Subsubsection",ExpressionUUID->"8f461d45-0647-c84b-9fe0-f72d3601c63f"],
Cell[371699, 9290, 1682, 40, 157, "Input",ExpressionUUID->"5485ed32-34f6-e64e-bd2a-b4e163c2b97f"]
}, Closed]],
Cell[CellGroupData[{
Cell[373418, 9335, 201, 3, 37, "Subsubsection",ExpressionUUID->"54169a90-c35c-7a4a-a37f-78c9753e8eeb"],
Cell[373622, 9340, 1627, 39, 124, "Input",ExpressionUUID->"c1bc4c8d-1ecd-654a-b9e2-f902b4037dfa"]
}, Closed]],
Cell[CellGroupData[{
Cell[375286, 9384, 225, 4, 37, "Subsubsection",ExpressionUUID->"e126572d-bdab-a047-b925-c2661290f09e"],
Cell[375514, 9390, 1438, 37, 105, "Input",ExpressionUUID->"3eac6f83-9820-5d4f-9acd-4f2df1b13510"]
}, Closed]],
Cell[CellGroupData[{
Cell[376989, 9432, 308, 5, 37, "Subsubsection",ExpressionUUID->"1d12da59-37f1-9842-ad9c-eb916041816f"],
Cell[377300, 9439, 3086, 70, 219, "Input",ExpressionUUID->"806c98e7-c027-de46-8fc2-cc2eda959f64"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[380435, 9515, 228, 4, 38, "Subsection",ExpressionUUID->"40e5692f-48f3-024d-af81-1a5914b0813b"],
Cell[CellGroupData[{
Cell[380688, 9523, 290, 4, 37, "Subsubsection",ExpressionUUID->"9332bfd4-b794-9542-bea9-284a11b178c6"],
Cell[380981, 9529, 699, 14, 31, "Input",ExpressionUUID->"5bc10ce3-9329-a946-86e7-d45107084797"]
}, Closed]],
Cell[CellGroupData[{
Cell[381717, 9548, 238, 4, 37, "Subsubsection",ExpressionUUID->"4a989280-28db-ca4e-bb0b-101f688af051"],
Cell[381958, 9554, 70990, 1166, 534, "Text",ExpressionUUID->"113413b2-0b67-2b41-9e95-6ce395a68d94"],
Cell[452951, 10722, 386, 8, 31, "Input",ExpressionUUID->"80d07db2-b412-a249-8575-62ea6579cc8c"],
Cell[CellGroupData[{
Cell[453362, 10734, 626, 15, 31, "Input",ExpressionUUID->"77841308-7f6b-cd46-a7ee-3ab0abd88dc2"],
Cell[453991, 10751, 600, 8, 70, "Output",ExpressionUUID->"bb340b07-23c9-e544-8120-b1430002d10b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[454628, 10764, 625, 15, 31, "Input",ExpressionUUID->"50b1474a-8391-ca4a-aad2-5206c808fb4f"],
Cell[455256, 10781, 575, 8, 70, "Output",ExpressionUUID->"7b72ddf0-a20a-e24f-897b-aa31de62e8be"]
}, Open  ]],
Cell[455846, 10792, 690, 16, 31, "Input",ExpressionUUID->"448ea2bb-3258-a841-a2d3-d7177e41cebf"]
}, Closed]],
Cell[CellGroupData[{
Cell[456573, 10813, 286, 4, 37, "Subsubsection",ExpressionUUID->"6221cf63-919d-e141-8412-466cad561c91"],
Cell[456862, 10819, 36923, 609, 221, "Text",ExpressionUUID->"56df0d81-b84a-0a40-8935-622d3a9520bb"],
Cell[493788, 11430, 437, 9, 31, "Input",ExpressionUUID->"2a84e9eb-3b52-7d4c-8269-c5737e1783b0"],
Cell[CellGroupData[{
Cell[494250, 11443, 458, 11, 31, "Input",ExpressionUUID->"c59ea1e9-aaa1-ba42-8ac2-a180175f33d0"],
Cell[494711, 11456, 550, 8, 70, "Output",ExpressionUUID->"66e6c993-6566-6043-bf9c-d63437e94735"]
}, Open  ]],
Cell[495276, 11467, 1539, 38, 94, "Input",ExpressionUUID->"58f5683c-eea5-5f4d-908b-138ff9f5786b"]
}, Closed]],
Cell[CellGroupData[{
Cell[496852, 11510, 333, 5, 37, "Subsubsection",ExpressionUUID->"27f808e6-e579-8044-bb27-905ebef0af91"],
Cell[497188, 11517, 23882, 394, 180, "Text",ExpressionUUID->"b9f0a34c-bb41-5b40-8075-20f44c1ed2ab"],
Cell[521073, 11913, 483, 9, 31, "Input",ExpressionUUID->"289e036b-59cc-294d-8968-9f3882987b07"],
Cell[CellGroupData[{
Cell[521581, 11926, 458, 11, 31, "Input",ExpressionUUID->"5cb44932-662b-c34f-9d5e-9a4f33e7d9e5"],
Cell[522042, 11939, 575, 8, 70, "Output",ExpressionUUID->"c9df0138-2546-cb49-9ada-122f380454b6"]
}, Open  ]],
Cell[522632, 11950, 1295, 35, 94, "Input",ExpressionUUID->"b3d30327-18b8-3e47-8ce7-7916c293687d"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[523966, 11990, 211, 4, 53, "Section",ExpressionUUID->"2609bf4c-7f5c-314e-a744-f86d4be283dd"],
Cell[524180, 11996, 91295, 1502, 343, "Text",ExpressionUUID->"025519cf-cc24-ac4a-b1b8-5f6eea41e8c2"],
Cell[CellGroupData[{
Cell[615500, 13502, 230, 4, 54, "Subsection",ExpressionUUID->"05a1e3c3-6472-f140-9524-e2a0b3b33a84"],
Cell[CellGroupData[{
Cell[615755, 13510, 347, 7, 28, "Input",ExpressionUUID->"4c28bf26-a6ce-8a42-b991-8ad29b361320"],
Cell[616105, 13519, 7033, 219, 100, "Output",ExpressionUUID->"9fc5228c-c14f-9d47-8509-abbeabec36d2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[623175, 13743, 174, 3, 45, "Subsubsection",ExpressionUUID->"d1205e47-b2b2-8049-873f-d577d1935580"],
Cell[623352, 13748, 521, 12, 28, "Input",ExpressionUUID->"77944f63-9d63-b443-b520-762d1ad7196a"]
}, Open  ]],
Cell[623888, 13763, 175, 2, 32, "Output",ExpressionUUID->"761abad9-bad4-c147-b063-c765c2efdfd5"],
Cell[CellGroupData[{
Cell[624088, 13769, 268, 4, 45, "Subsubsection",ExpressionUUID->"c1c83106-6478-7a43-8256-38a15359fc1e"],
Cell[624359, 13775, 568, 12, 28, "Input",ExpressionUUID->"7dd0efcc-831d-2146-bcde-2d5206d1b796"]
}, Open  ]],
Cell[624942, 13790, 178, 2, 32, "Output",ExpressionUUID->"0cd8eb1a-1805-3645-83a5-54e1e67fc719"]
}, Closed]],
Cell[CellGroupData[{
Cell[625157, 13797, 281, 5, 38, "Subsection",ExpressionUUID->"84fb6ddf-5941-1646-a85e-05e2cdfcccd9"],
Cell[CellGroupData[{
Cell[625463, 13806, 400, 8, 28, "Input",ExpressionUUID->"4f0f7fb9-3495-8046-973c-54dce4d78dcd"],
Cell[625866, 13816, 7573, 237, 100, "Output",ExpressionUUID->"89dc9c57-5392-2a48-b4f1-f0a625cdc6f1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[633476, 14058, 174, 3, 45, "Subsubsection",ExpressionUUID->"f891fb34-6e50-314e-814a-f6176168a751"],
Cell[CellGroupData[{
Cell[633675, 14065, 521, 12, 28, "Input",ExpressionUUID->"bac444e4-d3c7-c44a-b5df-bf4a9b7254fb"],
Cell[634199, 14079, 202, 3, 32, "Output",ExpressionUUID->"f411f88e-33d5-4543-b52f-fa5d8a6e2adb"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[634450, 14088, 268, 4, 45, "Subsubsection",ExpressionUUID->"de52ecc3-3d66-ed47-b247-e97eda5cd9ff"],
Cell[634721, 14094, 568, 12, 28, "Input",ExpressionUUID->"9dc6356e-d9c6-6346-924a-3f29d80b10de"]
}, Open  ]],
Cell[635304, 14109, 205, 3, 32, "Output",ExpressionUUID->"bf8071c8-a6af-b04b-9a1a-735b6f21ec9e"],
Cell[CellGroupData[{
Cell[635534, 14116, 275, 4, 45, "Subsubsection",ExpressionUUID->"89bf3bde-9ab7-3642-bb38-fedbc05ebf1d"],
Cell[CellGroupData[{
Cell[635834, 14124, 520, 12, 28, "Input",ExpressionUUID->"1cd050c1-6e1a-6243-90a4-a43e1a140b08"],
Cell[636357, 14138, 273, 4, 32, "Output",ExpressionUUID->"6e29d6eb-bd5d-4b43-8cab-1c4e662566be"]
}, Open  ]],
Cell[CellGroupData[{
Cell[636667, 14147, 474, 11, 48, "Input",ExpressionUUID->"af370f1a-24f6-be40-bddb-9b5981a4d4f8"],
Cell[637144, 14160, 262, 4, 32, "Output",ExpressionUUID->"7c78ffe1-954e-454f-b860-a306ab518f1e"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[637467, 14171, 326, 5, 38, "Subsection",ExpressionUUID->"1d0e9881-b171-4a46-a2b2-411ef3f6b270"],
Cell[CellGroupData[{
Cell[637818, 14180, 452, 9, 28, "Input",ExpressionUUID->"f341e008-d46f-1b45-aa33-57c075406c4a"],
Cell[638273, 14191, 6779, 211, 100, "Output",ExpressionUUID->"4b72ec0f-519b-ac49-8abc-8ad4b6f15df3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[645089, 14407, 174, 3, 45, "Subsubsection",ExpressionUUID->"11b204e6-f881-e543-8dad-ccf4ca9c7d34"],
Cell[CellGroupData[{
Cell[645288, 14414, 521, 12, 28, "Input",ExpressionUUID->"d0346b2e-9ddf-4946-bb08-4c0cc1da8ee2"],
Cell[645812, 14428, 226, 3, 32, "Output",ExpressionUUID->"d0aee9b4-492a-b845-92bf-fa82ed88805f"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[646087, 14437, 268, 4, 45, "Subsubsection",ExpressionUUID->"f67cd588-14a6-8c48-ae7c-32eac261ff26"],
Cell[CellGroupData[{
Cell[646380, 14445, 568, 12, 28, "Input",ExpressionUUID->"b1b19e21-b284-be42-8601-b45ff6370140"],
Cell[646951, 14459, 229, 3, 32, "Output",ExpressionUUID->"d97fa834-1034-e44c-8402-1562d4254167"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[647241, 14469, 380, 6, 38, "Subsection",ExpressionUUID->"f422df93-e1ea-ab45-b3d4-434ce64bd1ca"],
Cell[CellGroupData[{
Cell[647646, 14479, 500, 9, 28, "Input",ExpressionUUID->"8a42e4f1-503f-9342-a3a5-d904ad10fdb0"],
Cell[648149, 14490, 8938, 286, 100, "Output",ExpressionUUID->"f27bedc9-80b3-004d-aa1f-75abcf3b5632"]
}, Open  ]],
Cell[CellGroupData[{
Cell[657124, 14781, 303, 5, 45, "Subsubsection",ExpressionUUID->"a1468a1e-f05d-0444-8654-b8816172c043"],
Cell[657430, 14788, 613, 13, 28, "Input",ExpressionUUID->"c2b8f642-467b-1146-b824-9c8e450857d8"]
}, Open  ]],
Cell[658058, 14804, 231, 4, 32, "Output",ExpressionUUID->"5cf099bb-3adf-a846-aaca-dcc9bdd7ea76"],
Cell[CellGroupData[{
Cell[658314, 14812, 177, 3, 45, "Subsubsection",ExpressionUUID->"01cb555a-fbc9-434f-8e99-fb9fee8a5734"],
Cell[658494, 14817, 520, 12, 28, "Input",ExpressionUUID->"e4698304-029c-604e-b10a-7b7bc7067edb"]
}, Open  ]],
Cell[659029, 14832, 201, 3, 32, "Output",ExpressionUUID->"9cd9855b-42c0-5442-aba7-8e486df4e537"]
}, Closed]],
Cell[CellGroupData[{
Cell[659267, 14840, 432, 7, 38, "Subsection",ExpressionUUID->"07974ee4-7528-1c4a-880b-2e93e43f2a00"],
Cell[CellGroupData[{
Cell[659724, 14851, 552, 10, 28, "Input",ExpressionUUID->"00876137-16db-0548-93bb-af13054a2e63"],
Cell[660279, 14863, 17817, 548, 208, "Output",ExpressionUUID->"7e775ee2-0b33-c647-9e3b-8fbccc197e08"]
}, Open  ]],
Cell[CellGroupData[{
Cell[678133, 15416, 303, 5, 45, "Subsubsection",ExpressionUUID->"8f59f247-68ea-f24c-ae71-a9ae07bf2500"],
Cell[CellGroupData[{
Cell[678461, 15425, 613, 13, 28, "Input",ExpressionUUID->"405ebf02-e92e-6d4a-bb88-15a0374e024b"],
Cell[679077, 15440, 255, 4, 32, "Output",ExpressionUUID->"5c11986b-1bb6-644e-830f-a3fab1d658d1"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[679381, 15450, 177, 3, 45, "Subsubsection",ExpressionUUID->"6f2490e9-3c09-6b4f-8258-2195e938ceed"],
Cell[679561, 15455, 520, 12, 28, "Input",ExpressionUUID->"7db70e08-35ce-884c-b6ae-216252fe4b1d"]
}, Open  ]],
Cell[680096, 15470, 225, 3, 32, "Output",ExpressionUUID->"deb495be-6c63-144e-942e-09a57d34d942"]
}, Closed]],
Cell[CellGroupData[{
Cell[680358, 15478, 432, 7, 38, "Subsection",ExpressionUUID->"9b504da3-ad0b-f64f-a902-51b21c5b7b62"],
Cell[CellGroupData[{
Cell[680815, 15489, 552, 10, 28, "Input",ExpressionUUID->"47cbd477-f891-4c4e-8903-2c8bcf16445e"],
Cell[681370, 15501, 16454, 499, 165, "Output",ExpressionUUID->"63d89bfc-46dd-a44f-98fe-638702e43366"]
}, Open  ]],
Cell[CellGroupData[{
Cell[697861, 16005, 303, 5, 45, "Subsubsection",ExpressionUUID->"e79ad7ef-de4b-7b4d-bc28-99d8181d21da"],
Cell[CellGroupData[{
Cell[698189, 16014, 613, 13, 28, "Input",ExpressionUUID->"9616f8a6-2a43-3d49-86a1-6cc63d536e7d"],
Cell[698805, 16029, 255, 4, 32, "Output",ExpressionUUID->"914e89cd-6037-144c-a685-167eded2aafe"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[699109, 16039, 177, 3, 45, "Subsubsection",ExpressionUUID->"35d4d948-3b1f-6f41-939f-4d79fc020836"],
Cell[699289, 16044, 520, 12, 28, "Input",ExpressionUUID->"3165c482-166f-1540-989a-45cccd943c00"]
}, Open  ]],
Cell[699824, 16059, 225, 3, 32, "Output",ExpressionUUID->"36e17bfa-badb-1d40-a44d-1471c1a44359"]
}, Closed]],
Cell[CellGroupData[{
Cell[700086, 16067, 253, 4, 38, "Subsection",ExpressionUUID->"3d5448e9-c81e-564a-98d0-a24160c89bcd"],
Cell[CellGroupData[{
Cell[700364, 16075, 376, 8, 28, "Input",ExpressionUUID->"b16e0ab5-ae31-9540-819d-a0eb9c99b79b"],
Cell[700743, 16085, 19030, 560, 230, "Output",ExpressionUUID->"8d6345da-e659-ad4d-a698-256aace67093"]
}, Open  ]],
Cell[CellGroupData[{
Cell[719810, 16650, 170, 3, 45, "Subsubsection",ExpressionUUID->"bde8acd8-aac5-954f-8796-7b4eb0aedb55"],
Cell[CellGroupData[{
Cell[720005, 16657, 785, 16, 28, "Input",ExpressionUUID->"bd0d9a8a-64d8-204d-9d26-d0ec92fa4a69"],
Cell[720793, 16675, 487, 7, 32, "Output",ExpressionUUID->"f6a93f63-e9d0-9f42-a089-96d5dbe76da9"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[721329, 16688, 174, 3, 45, "Subsubsection",ExpressionUUID->"068ffa8d-2727-874b-a5fd-0de3e4d801ad"],
Cell[CellGroupData[{
Cell[721528, 16695, 521, 12, 28, "Input",ExpressionUUID->"3149357e-8d78-a34d-b4ab-e72521bd2a75"],
Cell[722052, 16709, 199, 3, 32, "Output",ExpressionUUID->"bb783221-a76e-344e-8c49-3c557449eadf"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[722300, 16718, 268, 4, 45, "Subsubsection",ExpressionUUID->"a6dbe2b9-6198-f74c-8a86-370d5fefaf9b"],
Cell[722571, 16724, 568, 12, 28, "Input",ExpressionUUID->"828c3d5d-2624-8648-beac-dc4c2cc5b790"]
}, Open  ]],
Cell[723154, 16739, 205, 3, 32, "Output",ExpressionUUID->"f9e4b402-c6e3-7e40-97ea-780775f2ee82"]
}, Closed]],
Cell[CellGroupData[{
Cell[723396, 16747, 308, 5, 38, "Subsection",ExpressionUUID->"49a4c270-beaa-2248-9bbf-bd37eb7d3d40"],
Cell[723707, 16754, 345, 8, 28, "Input",ExpressionUUID->"09dd261c-66df-e24c-98a8-2f096992e6d2"],
Cell[724055, 16764, 303, 5, 45, "Subsubsection",ExpressionUUID->"b406ab46-5abb-0f4b-b152-d528f720be6c"],
Cell[724361, 16771, 641, 14, 24, "Input",ExpressionUUID->"c71db3fb-f123-3045-a07f-528ff4a289ad"],
Cell[725005, 16787, 235, 5, 32, "Output",ExpressionUUID->"0171ddd2-0226-4543-93f7-ded55aae0b61"],
Cell[725243, 16794, 177, 3, 45, "Subsubsection",ExpressionUUID->"0154d8b4-24ca-de4b-b385-5a8671c03c8a"],
Cell[725423, 16799, 524, 13, 24, "Input",ExpressionUUID->"74c68244-de19-7541-b0b7-b40bb3c06673"],
Cell[725950, 16814, 203, 4, 32, "Output",ExpressionUUID->"98da4bd7-b22a-5542-8f97-2e8fff69ad83"]
}, Closed]],
Cell[CellGroupData[{
Cell[726190, 16823, 360, 6, 38, "Subsection",ExpressionUUID->"0a7d5382-e643-fd4e-9617-e8f9cc89a145"],
Cell[726553, 16831, 398, 9, 28, "Input",ExpressionUUID->"7925e5e1-57ab-f243-ab75-9940c6ab032b"],
Cell[726954, 16842, 303, 5, 45, "Subsubsection",ExpressionUUID->"e840cb92-214f-bd42-a1d9-fce8036c620b"],
Cell[CellGroupData[{
Cell[727282, 16851, 641, 14, 24, "Input",ExpressionUUID->"f06df217-915a-0045-b4a0-e662a3ffc09e"],
Cell[727926, 16867, 257, 5, 32, "Output",ExpressionUUID->"63558b11-a936-1f45-af59-883e3f8d793a"]
}, Open  ]],
Cell[728198, 16875, 177, 3, 45, "Subsubsection",ExpressionUUID->"de3e84e7-2508-f541-a326-ecdd2638b9f8"],
Cell[728378, 16880, 524, 13, 24, "Input",ExpressionUUID->"19e34b30-1001-864c-b842-c1cdecd64e3b"],
Cell[728905, 16895, 227, 4, 32, "Output",ExpressionUUID->"12ed4bbb-3e57-6446-b858-6a04411ea275"]
}, Closed]],
Cell[CellGroupData[{
Cell[729169, 16904, 360, 6, 38, "Subsection",ExpressionUUID->"d32c02bb-4a12-0d49-816a-77e6e1a9cb2a"],
Cell[729532, 16912, 394, 9, 28, "Input",ExpressionUUID->"a7d44694-1762-3444-99fc-17d6b1fb683f"],
Cell[729929, 16923, 303, 5, 45, "Subsubsection",ExpressionUUID->"c8fdf9f2-14fc-3b4b-9140-3feef5c71092"],
Cell[CellGroupData[{
Cell[730257, 16932, 641, 14, 24, "Input",ExpressionUUID->"d415c4fa-33eb-014f-9877-6fe53ec76b3c"],
Cell[730901, 16948, 259, 5, 32, "Output",ExpressionUUID->"e1754135-42b8-0b40-952e-2ef6a0c61bbc"]
}, Open  ]],
Cell[731175, 16956, 177, 3, 45, "Subsubsection",ExpressionUUID->"79863603-d67f-8441-93a9-b1fb9e839cc7"],
Cell[731355, 16961, 524, 13, 24, "Input",ExpressionUUID->"8af35b33-8550-704d-9585-9cd7e921a1e7"],
Cell[731882, 16976, 227, 4, 32, "Output",ExpressionUUID->"833b16b9-b3c5-584e-bad3-b94b000264d3"]
}, Closed]],
Cell[CellGroupData[{
Cell[732146, 16985, 360, 6, 38, "Subsection",ExpressionUUID->"83fd0638-3e1f-534d-8e29-883b8d834a68"],
Cell[732509, 16993, 393, 9, 28, "Input",ExpressionUUID->"330a0280-c4c1-9a4d-80cc-e975faf4c3b4"],
Cell[732905, 17004, 303, 5, 45, "Subsubsection",ExpressionUUID->"794945fb-2ef7-3b42-8276-07ab91ce7c71"],
Cell[CellGroupData[{
Cell[733233, 17013, 641, 14, 24, "Input",ExpressionUUID->"4dd1e563-7850-b943-bbb0-fcc14529ef07"],
Cell[733877, 17029, 257, 5, 32, "Output",ExpressionUUID->"10881e94-f932-4547-b9fd-e47a30eaa064"]
}, Open  ]],
Cell[734149, 17037, 177, 3, 45, "Subsubsection",ExpressionUUID->"97253f4f-f597-884d-ad63-bd6113e0a3d2"],
Cell[734329, 17042, 524, 13, 24, "Input",ExpressionUUID->"234a67dc-ceec-9349-92c2-0db4659dfd75"],
Cell[734856, 17057, 225, 4, 32, "Output",ExpressionUUID->"b031e191-b69f-a94d-93f3-81ff62b0fe25"]
}, Closed]],
Cell[CellGroupData[{
Cell[735118, 17066, 362, 6, 38, "Subsection",ExpressionUUID->"e2ef6a68-4b48-0244-8a54-fa236c49260a"],
Cell[735483, 17074, 396, 9, 28, "Input",ExpressionUUID->"c4f51896-802b-b142-9475-167cb2128669"],
Cell[735882, 17085, 303, 5, 45, "Subsubsection",ExpressionUUID->"7950e7de-d186-f74a-a8a5-fd54c8f10a81"],
Cell[CellGroupData[{
Cell[736210, 17094, 641, 14, 24, "Input",ExpressionUUID->"594386a8-7635-5547-a8e8-3f8f3ee44abb"],
Cell[736854, 17110, 257, 5, 32, "Output",ExpressionUUID->"782dae68-8def-ce40-afcd-2ade73c7e9b8"]
}, Open  ]],
Cell[737126, 17118, 177, 3, 45, "Subsubsection",ExpressionUUID->"74b8beab-fccc-3847-9404-d273ccfe093e"],
Cell[737306, 17123, 524, 13, 24, "Input",ExpressionUUID->"13c067e6-d03a-454f-b702-64e5d6226744"],
Cell[737833, 17138, 227, 4, 32, "Output",ExpressionUUID->"b5e9c3d8-de6a-e242-8bc9-4edf5338e601"]
}, Closed]],
Cell[CellGroupData[{
Cell[738097, 17147, 360, 6, 38, "Subsection",ExpressionUUID->"ee541790-f297-3b41-befe-9d0e0af4fc4c"],
Cell[738460, 17155, 396, 9, 28, "Input",ExpressionUUID->"80aa0a8e-b84a-7d42-9e5d-d22d69243ae4"],
Cell[738859, 17166, 303, 5, 45, "Subsubsection",ExpressionUUID->"939977d1-5cbd-5d42-8916-ddcb40e47c47"],
Cell[CellGroupData[{
Cell[739187, 17175, 641, 14, 24, "Input",ExpressionUUID->"3c99965e-f594-0045-a855-db2a5a70a964"],
Cell[739831, 17191, 259, 5, 32, "Output",ExpressionUUID->"73a51740-534d-2942-bc8c-9cb6fd119192"]
}, Open  ]],
Cell[740105, 17199, 177, 3, 45, "Subsubsection",ExpressionUUID->"e2961a94-c519-4047-9d59-e2044a39e1e9"],
Cell[CellGroupData[{
Cell[740307, 17206, 524, 13, 24, "Input",ExpressionUUID->"23808561-4edd-2e40-b114-c7d0948eb1e2"],
Cell[740834, 17221, 225, 4, 32, "Output",ExpressionUUID->"06886277-73e7-0a4b-9d2f-96bd14852f26"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[741108, 17231, 406, 6, 38, "Subsection",ExpressionUUID->"09e901c8-6c51-7448-9026-3aa7e530b4ae"],
Cell[CellGroupData[{
Cell[741539, 17241, 426, 9, 28, "Input",ExpressionUUID->"b4e7059a-5dc1-1842-bd93-d2532403606b"],
Cell[741968, 17252, 19140, 592, 230, "Output",ExpressionUUID->"1844c505-cd58-934a-b285-9b545519062d"]
}, Open  ]],
Cell[761123, 17847, 303, 5, 45, "Subsubsection",ExpressionUUID->"ed052706-41a9-4d4a-8a4e-68afd4db9247"],
Cell[CellGroupData[{
Cell[761451, 17856, 641, 14, 24, "Input",ExpressionUUID->"14f3fc78-f22b-274e-bb57-23f2ee51eef4"],
Cell[762095, 17872, 283, 5, 32, "Output",ExpressionUUID->"9d81bb58-a068-a748-b5fe-2b0f1565054e"]
}, Open  ]],
Cell[762393, 17880, 177, 3, 45, "Subsubsection",ExpressionUUID->"6b3589d0-7eb7-514a-b7ce-a798d85a97d5"],
Cell[762573, 17885, 524, 13, 24, "Input",ExpressionUUID->"7ae3f305-503a-3e4a-b179-c46706f9ec88"],
Cell[763100, 17900, 225, 4, 32, "Output",ExpressionUUID->"10f08a43-2814-7b4d-afc9-5eb03e3d4c53"]
}, Closed]],
Cell[CellGroupData[{
Cell[763362, 17909, 179, 3, 38, "Subsection",ExpressionUUID->"3bec1bea-cbef-a441-a045-8a88b7252d46"],
Cell[763544, 17914, 298, 7, 28, "Input",ExpressionUUID->"88806f8d-5537-8942-89a5-211422431bf7"],
Cell[763845, 17923, 16906, 520, 187, "Output",ExpressionUUID->"c542d6be-bf29-e540-a596-e43c57c149f2"],
Cell[780754, 18445, 168, 3, 45, "Subsubsection",ExpressionUUID->"039fe4b5-d318-574b-8b31-a774254f4caa"],
Cell[CellGroupData[{
Cell[780947, 18452, 550, 13, 24, "Input",ExpressionUUID->"91c9b5ce-1eee-b349-a7d8-40020d69029d"],
Cell[781500, 18467, 178, 3, 32, "Output",ExpressionUUID->"f784ab0a-0c29-b14b-bf44-db1d5e4a1dff"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[781727, 18476, 374, 6, 38, "Subsection",ExpressionUUID->"f5186099-17e1-0849-a468-bcce71b17fc4"],
Cell[CellGroupData[{
Cell[782126, 18486, 298, 7, 28, "Input",ExpressionUUID->"b0798158-bf6c-a544-b905-f4c823f51ef3"],
Cell[782427, 18495, 21612, 655, 252, "Output",ExpressionUUID->"28aa2426-a34b-b14e-b39f-2f80da84268d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[804076, 19155, 174, 3, 45, "Subsubsection",ExpressionUUID->"2e23cce6-d1dd-b446-a615-419e8b6d7cd9"],
Cell[CellGroupData[{
Cell[804275, 19162, 525, 13, 28, "Input",ExpressionUUID->"ddfb16ae-a679-3342-bc6c-48b5a05f3229"],
Cell[804803, 19177, 206, 4, 32, "Output",ExpressionUUID->"d146f53f-7308-624d-bb6b-fbf4ac01421e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[805058, 19187, 266, 4, 45, "Subsubsection",ExpressionUUID->"9202140e-c1f6-0146-af41-660a56d80a88"],
Cell[CellGroupData[{
Cell[805349, 19195, 570, 13, 28, "Input",ExpressionUUID->"d5746fb7-284c-794f-83e6-0b975c1c4a58"],
Cell[805922, 19210, 207, 4, 32, "Output",ExpressionUUID->"618afac4-6149-e947-9166-f213db43ee54"]
}, Open  ]]
}, Open  ]],
Cell[806156, 19218, 221, 4, 45, "Subsubsection",ExpressionUUID->"a74c0314-453e-174a-b275-e2dbd6475261"],
Cell[806380, 19224, 621, 14, 24, "Input",ExpressionUUID->"03a76afb-52ed-c640-9862-18d664851e52"],
Cell[807004, 19240, 227, 4, 32, "Output",ExpressionUUID->"7a6e033d-eee6-9c44-afea-569ead810413"]
}, Closed]],
Cell[CellGroupData[{
Cell[807268, 19249, 205, 4, 38, "Subsection",ExpressionUUID->"425a58b3-97d8-ce41-9e86-d9eab15ec7e1"],
Cell[CellGroupData[{
Cell[807498, 19257, 326, 7, 28, "Input",ExpressionUUID->"2b57a823-2f53-0f46-8ed3-84c4f0bd9ef9"],
Cell[807827, 19266, 22170, 666, 252, "Output",ExpressionUUID->"481d32e9-77fb-734b-a07f-ab43b901a956"]
}, Open  ]],
Cell[830012, 19935, 168, 3, 45, "Subsubsection",ExpressionUUID->"f769db25-cf4b-fe48-97c5-699816fa858c"],
Cell[CellGroupData[{
Cell[830205, 19942, 548, 13, 24, "Input",ExpressionUUID->"65aec95c-6057-fe43-98eb-e4729d3038f9"],
Cell[830756, 19957, 180, 3, 32, "Output",ExpressionUUID->"f376dbfe-247c-d54e-9c90-5d1174d8b9e9"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[830985, 19966, 253, 4, 38, "Subsection",ExpressionUUID->"3d09b413-0fda-f345-bf9a-07874290d5f6"],
Cell[CellGroupData[{
Cell[831263, 19974, 379, 8, 28, "Input",ExpressionUUID->"06ca99e4-9b0b-a441-b634-ace33659d420"],
Cell[831645, 19984, 22871, 694, 273, "Output",ExpressionUUID->"c3e8c0ee-6253-ec47-b7fc-ebb2b4388829"]
}, Open  ]],
Cell[854531, 20681, 168, 3, 45, "Subsubsection",ExpressionUUID->"e5ff7923-dcaa-ca43-8b80-d08aaecc4310"],
Cell[854702, 20686, 548, 13, 24, "Input",ExpressionUUID->"1d0f8264-b184-694d-a405-ebda81d52dd4"],
Cell[855253, 20701, 207, 4, 32, "Output",ExpressionUUID->"4b3810b5-ee5e-b844-ab08-7db05174ba50"]
}, Closed]],
Cell[CellGroupData[{
Cell[855497, 20710, 206, 4, 38, "Subsection",ExpressionUUID->"d7647f9c-3ed9-3d4f-a08e-785a6587d6cb"],
Cell[CellGroupData[{
Cell[855728, 20718, 322, 7, 28, "Input",ExpressionUUID->"2dbbe913-b9aa-f34a-b379-44e430f8df15"],
Cell[856053, 20727, 8757, 276, 122, "Output",ExpressionUUID->"d89288dd-f69b-e24e-8a49-a5f5ab4480bb"]
}, Open  ]],
Cell[864825, 21006, 174, 3, 45, "Subsubsection",ExpressionUUID->"35e64947-99f7-1045-b169-ef2f3352bf14"],
Cell[CellGroupData[{
Cell[865024, 21013, 548, 13, 24, "Input",ExpressionUUID->"6c80ac55-4516-f544-ab0b-3eb42efa6275"],
Cell[865575, 21028, 182, 3, 32, "Output",ExpressionUUID->"4d2037c2-9901-3949-9446-ebe5849da358"]
}, Open  ]],
Cell[CellGroupData[{
Cell[865794, 21036, 268, 4, 45, "Subsubsection",ExpressionUUID->"936f7470-59e5-1e4c-96e4-6c6aab2e84dc"],
Cell[866065, 21042, 574, 13, 28, "Input",ExpressionUUID->"49a99af6-52e1-8b4a-9053-29ab8f037d0b"]
}, Open  ]],
Cell[866654, 21058, 182, 3, 32, "Output",ExpressionUUID->"57d2b035-6553-8741-bba4-54602358025a"],
Cell[CellGroupData[{
Cell[866861, 21065, 221, 4, 45, "Subsubsection",ExpressionUUID->"2c996baf-d537-6745-8a37-8ee8cb9bc5bc"],
Cell[867085, 21071, 597, 14, 28, "Input",ExpressionUUID->"b1c87d5b-6413-3044-bb75-786c65fc19e8"]
}, Open  ]],
Cell[867697, 21088, 229, 4, 32, "Output",ExpressionUUID->"c066f762-461d-2f4a-a699-741b3a980332"]
}, Closed]],
Cell[CellGroupData[{
Cell[867963, 21097, 157, 3, 38, "Subsection",ExpressionUUID->"4a04183d-08f6-2248-8220-e95bcb7af714"],
Cell[868123, 21102, 298, 7, 28, "Input",ExpressionUUID->"91b88562-5313-9543-aff7-3306fad03c4c"],
Cell[868424, 21111, 10922, 346, 122, "Output",ExpressionUUID->"e8adaab0-bee4-9742-83cd-e5993630796d"],
Cell[879349, 21459, 171, 3, 45, "Subsubsection",ExpressionUUID->"a1bb827c-282c-8d40-8928-945900c69a17"],
Cell[CellGroupData[{
Cell[879545, 21466, 549, 13, 24, "Input",ExpressionUUID->"5cad5e9f-fdf1-0747-bdf7-8e4aed69e08e"],
Cell[880097, 21481, 210, 4, 32, "Output",ExpressionUUID->"0fabdffa-0225-a84d-8518-7b992527555b"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[880356, 21491, 157, 3, 38, "Subsection",ExpressionUUID->"2dc3a68f-0f11-6847-8034-486d02ef6993"],
Cell[880516, 21496, 300, 7, 28, "Input",ExpressionUUID->"77abef86-b745-ac43-b4d5-1af60d791f99"],
Cell[880819, 21505, 21458, 652, 273, "Output",ExpressionUUID->"0b5481b7-ec9d-ff43-a757-60c7a478269b"],
Cell[902280, 22159, 177, 3, 45, "Subsubsection",ExpressionUUID->"adeb5a20-cdf1-2649-8006-b06c55e0b43d"],
Cell[902460, 22164, 771, 16, 24, "Input",ExpressionUUID->"697ea50b-fdac-e441-aad2-4f7019693805"],
Cell[903234, 22182, 487, 8, 32, "Output",ExpressionUUID->"007bc9fb-5bbf-834e-bf60-de37b501d1fa"]
}, Closed]],
Cell[CellGroupData[{
Cell[903758, 22195, 374, 6, 38, "Subsection",ExpressionUUID->"cdf17696-4d13-864f-8ca7-1240d484e052"],
Cell[CellGroupData[{
Cell[904157, 22205, 300, 7, 28, "Input",ExpressionUUID->"ffe858f3-e1b1-5e4b-8f75-484722bca4ed"],
Cell[904460, 22214, 17453, 525, 187, "Output",ExpressionUUID->"2558e743-1feb-334f-bde3-8ff73b386d30"]
}, Open  ]],
Cell[921928, 22742, 221, 4, 45, "Subsubsection",ExpressionUUID->"2bbd9b20-0b93-0f4d-a010-11140b606f1b"],
Cell[CellGroupData[{
Cell[922174, 22750, 594, 14, 24, "Input",ExpressionUUID->"6c44a4c6-55d6-3c4f-9b0b-b9a70130e564"],
Cell[922771, 22766, 226, 4, 32, "Output",ExpressionUUID->"45aeebae-39ac-9947-b0a8-3f057aebb42f"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[923046, 22776, 208, 4, 38, "Subsection",ExpressionUUID->"7b5d1626-2fe7-3c41-bc9f-ad82ee7fb000"],
Cell[923257, 22782, 353, 8, 28, "Input",ExpressionUUID->"f3b18168-3d73-a64a-b3ab-5cb6d78ffd51"],
Cell[923613, 22792, 17959, 544, 230, "Output",ExpressionUUID->"5649be37-9d35-8a4b-bdfb-d6e51c11b781"],
Cell[941575, 23338, 174, 3, 45, "Subsubsection",ExpressionUUID->"b06ed08f-0fc2-f04a-8a2a-b9eec0d53560"],
Cell[CellGroupData[{
Cell[941774, 23345, 548, 13, 24, "Input",ExpressionUUID->"8e7ef6f9-6c78-2c46-9612-2e55f92788c3"],
Cell[942325, 23360, 206, 4, 32, "Output",ExpressionUUID->"0b0d65a0-1c78-ff48-85f9-59f8b300d1e9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[942568, 23369, 268, 4, 45, "Subsubsection",ExpressionUUID->"0a1b2a12-5208-8348-8e41-aa6cb5cf2bbf"],
Cell[942839, 23375, 574, 13, 28, "Input",ExpressionUUID->"95ea092a-84b0-084d-82f2-8531b1789692"]
}, Open  ]],
Cell[943428, 23391, 180, 3, 32, "Output",ExpressionUUID->"0e552380-3dbe-684e-85af-7e63501a7fb5"]
}, Closed]],
Cell[CellGroupData[{
Cell[943645, 23399, 256, 4, 38, "Subsection",ExpressionUUID->"09da417d-05bc-9540-b1b1-685207bad5e6"],
Cell[943904, 23405, 477, 11, 28, "Input",ExpressionUUID->"b36306ba-bfdf-8a42-8f81-0375abc513d7"],
Cell[944384, 23418, 174, 3, 45, "Subsubsection",ExpressionUUID->"923bc323-e6f1-804c-8236-8d189f0d241d"],
Cell[CellGroupData[{
Cell[944583, 23425, 548, 13, 24, "Input",ExpressionUUID->"e310df99-7ba8-bb4c-9b13-35ed3afeafa8"],
Cell[945134, 23440, 228, 4, 32, "Output",ExpressionUUID->"33558438-430d-9f4e-9d43-c9ec95c3bdd9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[945399, 23449, 268, 4, 45, "Subsubsection",ExpressionUUID->"5aa955bd-2220-c744-b448-725d7d439eb1"],
Cell[945670, 23455, 574, 13, 28, "Input",ExpressionUUID->"2789c842-e60f-5d40-b448-a28fabca5c0a"]
}, Open  ]],
Cell[946259, 23471, 205, 4, 32, "Output",ExpressionUUID->"0f2a48cf-e4dc-7a4b-b624-431e955ae188"]
}, Closed]]
}
]
*)

